package test.org.itscool.commons.file;

import java.net.URL;
import java.util.ArrayList;

import junit.framework.TestCase;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

import test.org.itscool.commons.file.sample.Sample1;
import test.org.itscool.commons.file.sample.Sample2;

public class TestLog extends TestCase{
	
	public TestLog(){
		AbstractLog log = SimpleLog.getInstance();
		log.setEncode("Shift_JIS");
		log.setInit(true);
		log.setLevel("info");
		log.setMode("disp");
		ArrayList patterns = new ArrayList();
		patterns.add("test.org.itscool.commons.file.sample.Sample1");
		
		log.setOutputClasses(patterns);
	}
	
	public void testOutput1(){
		System.out.println("******** testOutput1 ***********");
		Sample1 sample = new Sample1();
		sample.sampleMethod();
	}
	
	public void testOutput2(){
		System.out.println("******** testOutput2 ***********");
		Sample2 sample = new Sample2();
		sample.sampleMethod();
	}
	
	public void testOutput3(){
		AbstractLog log = SimpleLog.getInstance();
		ArrayList patterns = new ArrayList();
		log.setOutputClasses(patterns);
		
		System.out.println("******** testOutput3 ***********");
		Sample1 sample1 = new Sample1();
		sample1.sampleMethod();
		Sample2 sample2 = new Sample2();
		sample2.sampleMethod();
	}
	
	public void testOutput4() throws Exception{
		System.out.println("******** testOutput4 ***********");
		ClassLoader parent = ClassLoader.getSystemClassLoader();
		URL weberUrl = parent.getResource("test/org/itscool/commons/file/di-config-framework2.xml");
		BeanFactory factory = BeanFactory.getInstance();
		
		factory.create(weberUrl.getPath());
		SimpleLog log = (SimpleLog) factory.createInstance("Log");
		Sample1 sample1 = new Sample1();
		sample1.sampleMethod();
		Sample2 sample2 = new Sample2();
		sample2.sampleMethod();
	}
}
