package test.org.itscool.commons.bean;

import java.net.URL;
import java.util.List;

import junit.framework.TestCase;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.SimpleLog;

public class TestCreateLogInstance extends TestCase{
	
	public TestCreateLogInstance() throws Exception{
		ClassLoader parent = ClassLoader.getSystemClassLoader();
		URL weberUrl = parent.getResource("test/org/itscool/commons/bean/di-config-framework2.xml");
		BeanFactory factory = BeanFactory.getInstance();
		
		factory.create(weberUrl.getPath());
		
	}
	
	public void testCreateInstance(){
		BeanFactory factory = BeanFactory.getInstance();
		SimpleLog bean = (SimpleLog) factory.createInstance("Log");
		List outputClasses = bean.getOutputClasses();
		for(int i=0; i<outputClasses.size(); i++ ){
			String clazz = (String)outputClasses.get(i);
			assertNotNull(clazz);
		}
	}
	
	public void testCreateInstance2(){
		BeanFactory factory = BeanFactory.getInstance();
		SimpleLog bean = (SimpleLog) factory.createInstance("Log");
		List outputClasses = bean.getOutputClasses();
		assertEquals(bean.isOutputClass("org.itscool.weber.action.FrontServlet"), true);
	}
}
