package test.org.itscool.commons.bean;

import junit.framework.TestCase;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;

public class TestBeanUtil extends TestCase{
	public void testCreate(){
		try{
			SampleBean bean = (SampleBean)
				BeanUtil.createInstance("test.org.itscool.commons.bean.SampleBean");
		}catch(BeanUtilRuntimeException e){
			fail(e.getMessage());
		}
	}
	public void testGetInstance(){
		try{
			SampleSingletonBean bean = SampleSingletonBean.getInstance();
			bean.setName("hoge");
			
			SampleSingletonBean instance = (SampleSingletonBean)
				BeanUtil.getInstance("test.org.itscool.commons.bean.SampleSingletonBean");
			
			if( bean != instance ){
				fail("instance is matched");
			}
			assertEquals(instance.getName(), bean.getName());
			
		}catch(BeanUtilRuntimeException e){
			fail(e.getMessage());
		}
	}
	public void testSetInt(){
		try{
			SampleBean bean = (SampleBean)
				BeanUtil.createInstance("test.org.itscool.commons.bean.SampleBean");
			BeanUtil.setProperty(bean, "id", new Integer("10"));
			assertEquals( bean.getId(), 10 );
		}catch(BeanUtilRuntimeException e){
			fail(e.getMessage());
		}
	}
	
	public void testSetDouble(){
		try{
			SampleBean bean = (SampleBean)
				BeanUtil.createInstance("test.org.itscool.commons.bean.SampleBean");
			BeanUtil.setProperty(bean, "doubleVal", new Double("10.99"));
			assertEquals( new Double(String.valueOf(bean.getDoubleVal())), new Double("10.99") );
			
		}catch(BeanUtilRuntimeException e){
			fail(e.getMessage());
		}
	}
	
	public void testSetStr(){
		try{
			SampleBean bean = (SampleBean)
				BeanUtil.createInstance("test.org.itscool.commons.bean.SampleBean");
			BeanUtil.setProperty(bean, "name", "test");
			assertEquals( bean.getName(), "test" );
		}catch(BeanUtilRuntimeException e){
			fail(e.getMessage());
		}
	}
	
	public void testGetInt(){
		try{
			SampleBean bean = (SampleBean)
				BeanUtil.createInstance("test.org.itscool.commons.bean.SampleBean");
			bean.setId(100);
			int id = BeanUtil.getIntValue(bean, "id");
			assertEquals(id, 100);
		}catch(BeanUtilRuntimeException e){
			fail(e.getMessage());
		}
	}
	
	public void testGetDouble(){
		try{
			SampleBean bean = (SampleBean)
				BeanUtil.createInstance("test.org.itscool.commons.bean.SampleBean");
			bean.setDoubleVal(100.999);
			double doubleVal = BeanUtil.getDoubleValue(bean, "doubleVal");
			assertEquals( new Double(String.valueOf(doubleVal)), new Double("100.999") );
			
		}catch(BeanUtilRuntimeException e){
			fail(e.getMessage());
		}
	}
	
	public void testGetGetterName(){
		assertEquals("getAddress", BeanUtil.getGetterName("address"));
		assertEquals("getFirstName", BeanUtil.getGetterName("firstName"));
		assertEquals("getSecond_Name", BeanUtil.getGetterName("second_Name"));
	}
	
	public void testGetSetterName(){
		assertEquals("setAddress", BeanUtil.getSetterName("address"));
		assertEquals("setFirstName", BeanUtil.getSetterName("firstName"));
		assertEquals("setSecond_Name", BeanUtil.getSetterName("second_Name"));
	}
}
