package org.itscool.webersample.dao;

import java.util.Calendar;
import java.util.List;

import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.beanex.ScheduleEx;

/**
 * XPW[Ǘf[^ANZXNX
 */
public class ScheduleDao extends BaseDao {
	public static final String SORT_DATE = "SORT_DATE";
	public static final String SORT_USER = "SORT_USER";
	public static final String SORT_ST_TIME = "SORT_ST_TIME";
	public static final String SORT_ED_TIME = "SORT_ED_TIME";
	public static final String SORT_CONTENTS = "SORT_CONTENTS";
	
	private Criteria createSort(Criteria crt, String sortKind, boolean sort){
		if( sortKind == null ){
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
			
		}else if( sortKind.equals(SORT_DATE)){
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, sort);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, sort);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, sort);	
		}else if( sortKind.equals(SORT_USER)){
			crt.orderby(OfficeWorker.COLUM_firstName, sort);
			crt.orderby(OfficeWorker.COLUM_secondName, sort);
		}else if( sortKind.equals(SORT_ST_TIME)){
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, sort);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, sort);
		}else if( sortKind.equals(SORT_ED_TIME)){
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, sort);
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, sort);
		}else if( sortKind.equals(SORT_CONTENTS)){
			crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_contents, sort);
		}
		return crt;
	}
	/**
	 * wt̃XPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return wt̃XPW[ꗗ
	 */
	public List findByDate(int workerId, Calendar cal, String sortKind, boolean sort){
		List list = null;
		int year = cal.get(Calendar.YEAR); 
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, day);
		
		crt = createSort(crt, sortKind, sort);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * wt̃XPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return wt̃XPW[ꗗ
	 */
	public List findByDate(int workerId, int year, int month, int day, String contents, String sortKind, boolean sort){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, day);
		if(contents != null && contents.trim().length() != 0){
			crt.and();
			crt.like(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_contents, contents);
		}
		crt = createSort(crt, sortKind, sort);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * w茎̃XPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @param month 
	 * @return w茎̃XPW[ꗗ
	 */
	public List findByMonth(int workerId, int year, 
			int month, String contents, String sortKind, boolean sort){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		if(contents != null && contents.trim().length() != 0){
			crt.and();
			crt.like(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_contents, contents);
		}
		crt = createSort(crt, sortKind, sort);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * wÑXPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @return wÑXPW[ꗗ
	 */
	public List findByYear(int workerId, int year, String contents, String sortKind, boolean sort){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		if(contents != null && contents.trim().length() != 0){
			crt.and();
			crt.like(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_contents, contents);
		}
		crt = createSort(crt, sortKind, sort);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
//		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * wt̃XPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return wt̃XPW[ꗗ
	 */
	public List findByDate(int workerId, Calendar cal){
		List list = null;
		int year = cal.get(Calendar.YEAR); 
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, day);
		
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * wt̃XPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return wt̃XPW[ꗗ
	 */
	public List findByDate(int workerId, int year, int month, int day, String contents){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, day);
		if(contents != null && contents.trim().length() != 0){
			crt.and();
			crt.like(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_contents, contents);
		}
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * w茎̃XPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @param month 
	 * @return w茎̃XPW[ꗗ
	 */
	public List findByMonth(int workerId, int year, 
			int month, String contents){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		if(contents != null && contents.trim().length() != 0){
			crt.and();
			crt.like(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_contents, contents);
		}
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * wÑXPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @return wÑXPW[ꗗ
	 */
	public List findByYear(int workerId, int year, String contents){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		if(contents != null && contents.trim().length() != 0){
			crt.and();
			crt.like(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_contents, contents);
		}
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * XPW[擾܂
	 * @param scheduleId o^ς݂̃XPW[ID
	 * @return XPW[
	 */
	public ScheduleEx findById(int scheduleId){
		List list = null;
		ScheduleEx schedule = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.PK_COLUM_scheduleID, scheduleId);
		list = this.select(crt);
		if(list.size() > 0 ){
			schedule = (ScheduleEx)list.get(0);
		}
		return schedule;
		
	}
	
	/**
	 * w肳ꂽɍvXPW[擾܂
	 * @param searchItem tB[h
	 * @param searchKey 
	 * @return ɍvXPW[
	 */
	public List find(String searchItem,Object searchKey){
		Criteria crt = new Criteria(ScheduleEx.class);
		if(searchKey == null){
		    searchKey = "-1";
		}
		crt.eq(ScheduleEx.TABLE+"."+searchItem, searchKey);
		return select(crt);
	}
	
	/**
	 * XPW[S擾܂
	 * @param workerId ]ƈID
	 * @return XPW[S
	 */
    public List getAllData(int workerId){
		List list = null;
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_workerId, workerId);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
    /**
	 * wt̃XPW[擾܂
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return wt̃XPW[ꗗ
	 */
	public List findByDate( int year, 
			int month, int day){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, day);
		
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * wt̃XPW[擾܂
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return wt̃XPW[ꗗ
	 */
	public List findByDate( Calendar cal){
		List list = null;
		int year = cal.get(Calendar.YEAR); 
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, day);
		
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * w茎̃XPW[擾܂
	 * @param year N
	 * @param month 
	 * @return w茎̃XPW[ꗗ
	 */
	public List findByMonth( int year, 
			int month){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.and();
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, month);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
	
	/**
	 * wÑXPW[擾܂
	 * @param workerId ]ƈID
	 * @param year N
	 * @return wÑXPW[ꗗ
	 */
	public List findByYear( int year){
		List list = null;
		
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, year);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
    /**
	 * XPW[S擾܂
	 * @return XPW[S
	 */
    public List getAllData(){
		List list = null;
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_year, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_month, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_day, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_startMinute, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endTime, true);
		crt.orderby(ScheduleEx.TABLE+"."+ScheduleEx.COLUM_endMinute, true);
		
		list = this.select(crt);
		
		return list;
	}
    
    /**
     * XPW[o^܂
     * @param schedule XPW[
     * @return o^̃XPW[ID
     */
    public int save(ScheduleEx schedule){
        Criteria crt = new Criteria(ScheduleEx.class);
        int id = getNewIdFromAutoNumber(ScheduleEx.TABLE);
		schedule.setScheduleID(id);
		this.insert(crt, schedule);
		return id;
    }
    
    /**
     * XPW[XV܂
     * @param schedule XPW[
     */
    public void update(ScheduleEx schedule){
        Criteria crt = new Criteria(ScheduleEx.class);
        crt.eq(ScheduleEx.TABLE+"."+ScheduleEx.PK_COLUM_scheduleID, schedule.getScheduleID());
		this.update(crt, schedule);
    }
    
    /**
     * XPW[폜܂
     * @param schedule XPW[
     */
    public void delete(ScheduleEx schedule){
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE + "." + ScheduleEx.PK_COLUM_scheduleID, schedule.getScheduleID());
		this.delete(crt);
	}
    
    /**
     * XPW[폜܂
     * @param scheduleId XPW[ID
     */
    public void delete(int scheduleId){
		Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE + "." + ScheduleEx.PK_COLUM_scheduleID, scheduleId);
		this.delete(crt);
	}
    
    /**
     * XPW[폜܂
     * @param workerId ]ƈID
     */
    public void deleteByWorker(String workerId){
    	Criteria crt = new Criteria(ScheduleEx.class);
		crt.eq(ScheduleEx.TABLE + "." + ScheduleEx.COLUM_workerId, workerId);
		this.delete(crt);
    }
}
