package org.itscool.webersample.action.sisetu;

import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.action.Globals;
import org.itscool.weber.user.User;
import org.itscool.webersample.action.schedule.ScheduleUtil;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.bean.Sisetu;
import org.itscool.webersample.bean.SisetuYoyaku;
import org.itscool.webersample.dao.SisetuDao;
import org.itscool.webersample.dao.SisetuYoyakuDao;

/**
 * @author kano
*/
public class SisetuYoyakuShowRegistAction extends Action{
	public void doValidate(ActionBucket bucket){
		User user = (User)bucket.getAttributeFromSession(Globals.REQ_PARAM_USER);
		
		if( user != null && user.getRole().getName().equals("admin") ){
			this.putMessage("aa", "Ǘ҃[U͎{݂\񂷂邱Ƃ͂ł܂B");
		}
	}
	public String doExecute( ActionBucket bucket ){
        SisetuYoyaku form = (SisetuYoyaku)bucket.getForm();
        SisetuYoyakuDao dao = new SisetuYoyakuDao();
        SisetuYoyaku stack = dao.getSisetuYoyaku(form.getId());
        if(stack!=null){
        	form = stack;
        }else{
        	SisetuDao sisetuDao = new SisetuDao();
        	Sisetu sisetu = sisetuDao.getSisetu(form.getSisetuId());
        	OfficeWorker worker = (OfficeWorker)bucket.getAttributeFromSession("login.worker");
        	form.setSisetu(sisetu);
        	form.setWorker(worker);
        }
        bucket.setAttribute("yoyaku", form);
        
        bucket.setAttribute("days", ScheduleUtil.getDays());
        bucket.setAttribute("months", ScheduleUtil.getMonths());
        bucket.setAttribute("years", ScheduleUtil.getYears());
        bucket.setAttribute("hours", ScheduleUtil.getHours());
        bucket.setAttribute("minutes", ScheduleUtil.getMinutes());
        
        return "success";
    }
    
	
}
