package org.itscool.webersample.action.schedule;
import java.util.List;

import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.dao.OfficeWorkerDao;
import org.itscool.webersample.dao.ScheduleDao;

/**
 * XPW[Ǘ XPW[Xg`ŕ\ANV
 * file name : ScheduleSelectWorkerAction.java <BR>
 * @version 1.00A 2003/10/16
 * @author kano
*/
public class ScheduleSelectListAction extends Action{
	/**
	 * doPostM <BR>
	 * IꂽЈ擾AZbVɓo^܂B
	 * @param mapping ActionMapping ANV}bsO
	 * @param form ActionForm ANVtH[
	 * @param req HttpServletRequest NCAg̃NGXg
	 * @param res HttpServletResponse NCAgɕԂX|X
	 * @return ActionForward ANVtH[h
	 */
	public String doExecute( ActionBucket bucket ){   
		
		ScheduleSearchForm form = (ScheduleSearchForm)bucket.getForm();
        int year = form.getYear();
        int month = form.getMonth();
        int day = form.getDay();
        int workerId = form.getWorkerId();
        String contents = form.getContents();
        
        OfficeWorkerDao workerDAO = new OfficeWorkerDao();
        OfficeWorker worker = null;
        if(workerId != -1){
        	List list = workerDAO.find(OfficeWorker.PK_COLUM_id, String.valueOf(workerId));
        	if(list.size() > 0){
        		worker = (OfficeWorker)list.get(0);
        		workerId = worker.getId();
        	}else{
        		workerId = -1;
        	}
        }
		ScheduleDao scheduleDao = new ScheduleDao();
		
		if(this.getParameter("submit_list_delete")!=null ){
			for(int i=0; i<form.getScheduleIdList().size(); i++){
				String scheduleIdStr = (String)form.getScheduleIdList().get(i);
				int scheduleId = Integer.parseInt(scheduleIdStr);
				scheduleDao.delete(scheduleId);
			}
        }
		
		String sortKind = null;
		boolean sort = true;
		if( this.getParameter("SORT_DATE_ASC") != null ){
			sort = true;
		}else if(this.getParameter("SORT_ST_TIME_ASC") != null ){
			sort = true;
		}else if(this.getParameter("SORT_ED_TIME_ASC") != null ){
			sort = true;
		}else if(this.getParameter("SORT_USER_ASC") != null ){
			sort = true;
		}else if(this.getParameter("SORT_CONTENTS_ASC") != null ){
			sort = true;
		}else if( this.getParameter("SORT_DATE_DSC") != null ){
			sort = false;
		}else if(this.getParameter("SORT_ST_TIME_DSC") != null ){
			sort = false;
		}else if(this.getParameter("SORT_ED_TIME_DSC") != null ){
			sort = false;
		}else if(this.getParameter("SORT_USER_DSC") != null ){
			sort = false;
		}else if(this.getParameter("SORT_CONTENTS_DSC") != null ){
			sort = false;
		}
		
		List schedules;
		if(worker != null && year != -1 && month != -1 && day != -1 && contents != null && contents.length() != 0){
			schedules = scheduleDao.findByMonth(workerId, year, month, contents, sortKind, sort);
		}else if(worker != null && year != -1 && month != -1 && day != -1){
			schedules = scheduleDao.findByDate(workerId, year, month, day, contents, sortKind, sort);
		}else if(worker != null && year != -1 && month != -1 ){
			schedules = scheduleDao.findByMonth(workerId, year, month, contents, sortKind, sort);
		}else if(worker != null && year != -1 ){
			schedules = scheduleDao.findByYear(workerId, year, contents, sortKind, sort);
		}else if(worker != null){
			schedules = scheduleDao.getAllData(workerId);
		}else{
			schedules = scheduleDao.getAllData();
		}
		bucket.setAttribute("year", new Integer(year));
        bucket.setAttribute("month", new Integer(month));
        bucket.setAttribute("schedules", schedules);
        
        bucket.setAttribute("days", ScheduleUtil.getDays());
        bucket.setAttribute("months", ScheduleUtil.getMonths());
        bucket.setAttribute("years", ScheduleUtil.getYears());
        bucket.setAttribute("schedule", form);
		bucket.setAttribute("workers", workerDAO.getAllData());
        return "success";
	}
	
}
