package org.itscool.webersample.action.schedule;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.dao.OfficeWorkerDao;
import org.itscool.webersample.tag.ScheduleCalendarDrawComponent;

/**
 * XPW[Ǘ O[vʂŃXPW[\ANV
 * file name : ScheduleSelectWorkerAction.java <BR>
 * @version 1.00A 2003/10/16
 * @author kano
*/
public class ScheduleSelectGroupAction extends Action{
	
	/**
	 * doPostM <BR>
	 * IꂽЈ擾AZbVɓo^܂B
	 * @param mapping ActionMapping ANV}bsO
	 * @param form ActionForm ANVtH[
	 * @param req HttpServletRequest NCAg̃NGXg
	 * @param res HttpServletResponse NCAgɕԂX|X
	 * @return ActionForward ANVtH[h
	 */
	public String doExecute( ActionBucket bucket ){   
        
		ScheduleSearchForm form = (ScheduleSearchForm)bucket.getForm();
		int workerId = form.getWorkerId();
        OfficeWorkerDao workerDAO = new OfficeWorkerDao();
		List list = workerDAO.find(OfficeWorker.PK_COLUM_id, String.valueOf(workerId));
		
        int year = form.getYear();
        int month = form.getMonth();
        int day = form.getDay();
        Calendar cal = new GregorianCalendar();
        
        if( this.getParameter("submit_before") == null && 
        	this.getParameter("submit_next") == null){
//        	cal.clear();
//            cal.set(Calendar.YEAR, year);
//            cal.set(Calendar.MONTH, (month-1));
            
        }else if (this.getParameter("submit_before") != null) {
        	cal.set(Calendar.YEAR, year);
            cal.set(Calendar.MONTH, (month-1));
            cal.set(Calendar.DAY_OF_MONTH, day);
            cal.add(Calendar.WEEK_OF_MONTH, -1);
            
        }else if (this.getParameter("submit_next") != null) {
        	cal.set(Calendar.YEAR, year);
            cal.set(Calendar.MONTH, (month-1));
            cal.set(Calendar.DAY_OF_MONTH, day);
            cal.add(Calendar.WEEK_OF_MONTH, +1);
        }
        if(list.size() > 0){
        	OfficeWorker worker = (OfficeWorker)list.get(0);
        	bucket.setAttribute("personName", worker.getFirstName() + " " + worker.getSecondName());
        }
        
        bucket.setAttribute("workerId", String.valueOf(workerId));
		bucket.setAttribute("calendar", cal);
		bucket.setAttribute("year", String.valueOf(cal.get(Calendar.YEAR)));
		bucket.setAttribute("month", String.valueOf(cal.get(Calendar.MONTH)+1));
		bucket.setAttribute("day", String.valueOf(cal.get(Calendar.DAY_OF_MONTH)));
		bucket.setAttribute(ScheduleCalendarDrawComponent.WORKER_ID_PARAM_NAME, String.valueOf(workerId));
        
        return "success";
	}
}
