/*
 * 쐬: 2003/10/07
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package org.itscool.webersample.action.company;

import java.io.IOException;
import java.util.List;

import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserDao;
import org.itscool.weber.user.UserUtil;
import org.itscool.webersample.bean.GoStatus;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.bean.OfficialTitle;
import org.itscool.webersample.bean.Post;
import org.itscool.webersample.dao.GoStatusDao;
import org.itscool.webersample.dao.OfficeWorkerDao;
import org.itscool.webersample.dao.OfficialTitleDao;
import org.itscool.webersample.dao.PostDao;
import org.itscool.webersample.dao.ScheduleDao;

/**
 * ]ƈo^ANV<BR>
 * @author kano
 */
public class WorkerRegistAction extends Action{
	
	/**
	 * Јo^tH[̓̓`FbN
	 */
	protected void doValidate(ActionBucket bucket) {
	    OfficeWorkerDao workerDao = new OfficeWorkerDao();
	  	String workerId = (String)getParameter("workerId");
	  	
	  	//pX[h̓̓`FbN
		if (!isNotNull("password")) putMessage("I2001");
		//]ƈԍ̓̓`FbN
		if (!isNotNull("workerId")) {
            putMessage("I2002");
		} else if (!isInt("workerId")) {
            putMessage("I2003");
		} else if(	this.getParameter("submit_add") != null &&
			workerDao.find(OfficeWorker.COLUM_workerId, workerId).size() > 0 ){
            putMessage("I2004");
		}
		//̑I`FbN
		if (!isNotNull("postId")) putMessage("I2005");
		//ȆI`FbN
		if (!isNotNull("titleId")) putMessage("I2006");
        //O̓̓`FbN
		if( !isNotNull("firstName")) putMessage("I2007");
        //O̓̓`FbN
        if( !isNotNull("secondName")) putMessage("I2008");
        //[AhX̓̓`FbN
        if( !isNotNull("mailAddr")) putMessage("I2009");
	}
    
	/**
	 * Јo^ANV
	 * @param bucket ActionBucketCX^X
	 */
	public String doExecute(ActionBucket bucket ) throws Exception {
	    OfficeWorker worker = (OfficeWorker)bucket.getForm();
		
		if ( (this.getParameter("id") == null || this.getParameter("id").equals("-1"))
				&& this.getParameter("submit_regist") != null) {
			addPerson(worker);	//VKǉ
		}else if(this.getParameter("submit_update") != null){
 			editPerson(worker);	//ҏW
		}else if(this.getParameter("submit_delete") != null){
			delPerson(worker);	//폜
		}
        bucket.setAttribute("person", worker);
        
		return "success";
	}
	
	/**
	 * ]ƈǉ܂B
	 * @param worker ]ƈtH[Bean
	 * @return String ]ƈ̓o^ɐꍇ"success"
	 * Ԃ܂B<BR>
	 * ]ƈԍɓo^ς݂̂̂łꍇ"primaryS
	 * etId"Ԃ܂B
	 */
	private void addPerson(OfficeWorker worker) {
		PostDao postDao = new PostDao();
		OfficialTitleDao titleDao = new OfficialTitleDao();
		
        Post post = postDao.getPost(worker.getPostId());
        OfficialTitle title = titleDao.getOfficialTitle(worker.getTitleId());
        
		//]ƈ̓o^
		OfficeWorkerDao workerDAO = new OfficeWorkerDao();
	  	worker.setPost(post);
        worker.setTitle(title);
        
        
		try{
			//[U̒ǉ
			User user = new User();
			user.setName(worker.getWorkerId());
			user.setPwd(worker.getPassword());
			//Ј̒ǉ
			if( UserUtil.insertUser("guest", user) ){
				worker.setUserId(user.getId());
				workerDAO.save(worker);
			}
		}catch( IOException ioe ){
			throw new RuntimeException(ioe.getMessage());
		}
		
		//s\ւ̓o^
		GoStatusDao goDao = new GoStatusDao();
        GoStatus gostatus = new GoStatus();
        gostatus.setWorkerId(worker.getId());
        gostatus.setStatus("---");
        goDao.save(gostatus);
	}
	
	/**
	 * ]ƈҏW܂B
	 * @param worker ]ƈtH[Bean
	 * @return String ]ƈ̓o^ɐꍇ"success"
	 * Ԃ܂B<BR>
	 * ]ƈԍɓo^ς݂̂̂łꍇ"primaryS
	 * etId"Ԃ܂B
	 * @throws Exception
	 */
	private void editPerson(OfficeWorker worker) {
		
		PostDao postDao = new PostDao();
		OfficialTitleDao titleDao = new OfficialTitleDao();
		
        Post post = postDao.getPost(worker.getPostId());
        OfficialTitle title = titleDao.getOfficialTitle(worker.getTitleId());
        
        //]ƈ̓o^
		OfficeWorkerDao workerDAO = new OfficeWorkerDao();
	  	worker.setPost(post);
        worker.setTitle(title);
		
        try{
        	//[U̍XV
        	UserDao userDao = new UserDao();
        	User user = userDao.getUser("guest", worker.getWorkerId());
        	worker.setUser(user);
        	worker.setUserId(user.getId());
        	user.setName(worker.getWorkerId());
			user.setPwd(worker.getPassword());
			
			UserUtil.updateUser("guest", user);
			workerDAO.update(worker);
		}catch( IOException ioe ){
			throw new RuntimeException(ioe.getMessage());
		}
	}
		
	/**
	 * ]ƈ폜܂B
	 * @param worker ]ƈtH[Bean
	 * @return String ]ƈ̓o^ɐꍇ"success"
	 * Ԃ܂B<BR>
	 * ]ƈԍɓo^ς݂̂̂łꍇ"primaryS
	 * etId"Ԃ܂B
	 * @throws Exception
	 */
	private void delPerson(OfficeWorker worker) {
		//]ƈ̓o^
		OfficeWorkerDao workerDAO = new OfficeWorkerDao();
			
		//XPW[̍폜
		ScheduleDao scheduleDao = new ScheduleDao();
		scheduleDao.deleteByWorker(worker.getWorkerId());
		
        //s\ւ̓o^
        GoStatusDao gostatusDAO = new GoStatusDao();
        List gostatuslist = gostatusDAO.findByWorkerId(worker.getId());
        if( gostatuslist.size() > 0){
	        GoStatus gostatus = (GoStatus)gostatuslist.get(0);
	        gostatusDAO.delete(gostatus);
        }

		//Ј̍폜
		workerDAO.delete(worker);
		
        try{
        	//[U̍폜
        	UserDao userDao = new UserDao();
        	User user = userDao.getUser("guest", worker.getWorkerId());
        	UserUtil.deleteUser("guest", user);
		}catch( IOException ioe ){
		    throw new RuntimeException(ioe.getMessage());
	    }
		
	}
    
}
