/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.user;

import java.util.List;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.util.DataInUtil;
import org.itscool.weber.user.RoleDbManager;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserDao;

public class CreateUserForDb {
    static final String OPTION_UP = "-u";
    static final String OPTION_NEW = "-c";
    static final String OPTION_DEL = "-d";
    static final String OPTION_LIST = "-l";

    public static void main(String[] argv) throws Exception {
        boolean append = true;
        String user = "";
        String role = "";
        String path = "";
        if (argv.length < 3) {
            CreateUserForDb.showParamError();
            return;
        }
        if (argv[0].equals(OPTION_NEW)) {
            append = false;
        }
        path = argv[1];
        BeanFactory factory = BeanFactory.getInstance();
        factory.create(path);
        ConnectionManager conMgr = (ConnectionManager)factory.createInstance("ConnectionManager");
        conMgr.init();
        if (argv[0].equals(OPTION_NEW) || argv[0].equals(OPTION_UP)) {
            role = argv[2];
            user = argv[3];
            CreateUserForDb.createUser(role, user, append);
        } else if (argv[0].equals(OPTION_DEL)) {
            role = argv[2];
            user = argv[3];
            CreateUserForDb.deleteUser(role, user);
        } else if (argv[0].equals(OPTION_LIST)) {
            CreateUserForDb.showUserList(path);
        } else {
            CreateUserForDb.showParamError();
            return;
        }
        conMgr.destroy();
    }

    public static void createUser(String roleName, String userName, boolean append) throws Exception {
        String pwd = DataInUtil.askString((String)"\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        if (!DataInUtil.askString((String)"\u518d\u5ea6\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044").equals(pwd)) {
            System.out.println("\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u9055\u3044\u307e\u3059");
            return;
        }
        RoleDbManager roleDbManager = RoleDbManager.getInstance();
        if (roleDbManager.add(roleName, userName, pwd)) {
            TransactionUtil.commitTransaction();
            System.out.println("\u30e6\u30fc\u30b6\u30921\u4ef6\u8ffd\u52a0\u3057\u307e\u3057\u305f");
        } else {
            System.out.println("\u3053\u306e\u30e6\u30fc\u30b6\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
        }
    }

    public static void deleteUser(String roleName, String userName) throws Exception {
        boolean ret = DataInUtil.askBoolean((String)("[" + userName + "] \u3092\u524a\u9664\u3057\u3066\u3044\u3044\u3067\u3059\u304b\uff1f[y/n]"), (String)"y");
        if (!ret) {
            System.out.println("\u64cd\u4f5c\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f");
            return;
        }
        RoleDbManager roleDbManager = RoleDbManager.getInstance();
        roleDbManager.delete(roleName, userName);
        TransactionUtil.commitTransaction();
        System.out.println("\u30e6\u30fc\u30b6\u30921\u4ef6\u524a\u9664\u3057\u307e\u3057\u305f");
    }

    public static void showUserList(String path) throws Exception {
        UserDao dao = new UserDao();
        List userList = dao.getAllData();
        System.out.println("[\u30e6\u30fc\u30b6\u4e00\u89a7]");
        int i = 0;
        while (i < userList.size()) {
            User user = (User)userList.get(i);
            System.out.println(user.getName());
            ++i;
        }
    }

    public static void showParamError() {
        System.out.println("\u30b3\u30de\u30f3\u30c9\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u9055\u3044\u307e\u3059");
        System.out.println("");
        System.out.println("\u3010\u30b3\u30de\u30f3\u30c9\u306e\u66f8\u5f0f");
        System.out.println("");
        System.out.println(" java org.itscool.weber.tool.CreateUser |[-u][-c][-d][-l]| [PATH] [USER]");
        System.out.println("");
        System.out.println(" \u3010\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u89e3\u8aac");
        System.out.println("");
        System.out.println("  PATH \uff1a \u6a29\u9650\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u5148\u3092\u6307\u5b9a\u3057\u307e\u3059(\u5fc5\u9808)");
        System.out.println("  -u   \uff1a \u6a29\u9650\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306b\u30e6\u30fc\u30b6\u3092\u8ffd\u52a0\u3057\u307e\u3059");
        System.out.println("  -c   \uff1a \u6a29\u9650\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306b\u30e6\u30fc\u30b6\u3092\u65b0\u898f\u306b\u4f5c\u6210\u3057\u307e\u3059");
        System.out.println("          \u65e2\u5b58\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3059\u308b\u3070\u3042\u306f\u4e0a\u66f8\u304d\u3055\u308c\u307e\u3059");
        System.out.println("          (\u5f15\u6570\u3092\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u8ffd\u52a0\u3055\u308c\u307e\u3059)");
        System.out.println("  -d   \uff1a \u6307\u5b9a\u3055\u308c\u305f\u30e6\u30fc\u30b6\u3092\u524a\u9664\u3057\u307e\u3059");
        System.out.println("  -l   \uff1a \u6a29\u9650\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u30e6\u30fc\u30b6\u306e\u4e00\u89a7\u3092\u8868\u793a\u3057\u307e\u3059");
        System.out.println("  USER \uff1a \u30e6\u30fc\u30b6\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059(\u5fc5\u9808)");
        System.out.println("");
    }
}

