/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.testcase;

import java.io.IOException;
import java.util.LinkedList;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.weber.testcase.FieldData;
import org.itscool.weber.testcase.RecordData;
import org.itscool.weber.testcase.TableData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbTestConfigReader
extends XmlConfigReader {
    protected void doCreate(LinkedList dataList) throws IOException {
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at weber-message.xml(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList rolesList = root.getElementsByTagName("table");
        int i = 0;
        while (i < rolesList.getLength()) {
            Node roles = rolesList.item(i);
            NamedNodeMap nodeMap = roles.getAttributes();
            Node name = nodeMap.getNamedItem("name");
            String tableName = name.getNodeValue();
            TableData tableData = new TableData();
            tableData.setTableName(tableName);
            this.createRecordList(roles, tableData);
            dataList.add(tableData);
            ++i;
        }
    }

    protected void createRecordList(Node table, TableData tableData) {
        NodeList rolesChilds = table.getChildNodes();
        int i = 0;
        while (i < rolesChilds.getLength()) {
            Node message = rolesChilds.item(i);
            if (message.getNodeName().equals("record")) {
                RecordData recordData = new RecordData();
                this.createFieldList(message, recordData);
                tableData.addRecordData(recordData);
            }
            ++i;
        }
    }

    protected void createFieldList(Node record, RecordData recordList) {
        NamedNodeMap attributes = record.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node name = attributes.item(i);
            String fieldName = name.getNodeName();
            String value = name.getNodeValue();
            FieldData fieldMap = new FieldData();
            fieldMap.setName(fieldName);
            fieldMap.setValue(value);
            recordList.addFieldData(fieldMap);
            ++i;
        }
    }
}

