/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ByteUtil {
    public static final byte[] LINE = new byte[]{13, 10};

    public static byte[] getLineCrLf(byte[] buffer, int startPos) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        int bufSize = buffer.length;
        int i = startPos;
        while (i + 1 < bufSize && (buffer[i] != LINE[0] || buffer[i + 1] != LINE[1])) {
            bo.write(buffer[i]);
            ++i;
        }
        byte[] byteArray = bo.toByteArray();
        try {
            bo.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArray;
    }

    public static int indexof(byte[] buffer, byte[] key) {
        int bufSize = buffer.length;
        int keySize = key.length;
        int i = 0;
        int j = 0;
        while (i < bufSize) {
            if (buffer[i] != key[j]) {
                j = 0;
            } else {
                if (keySize == j + 1) {
                    return i - keySize;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public static byte[] copyByteData(byte[] dataB, int off, int len) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            bo.write(dataB, off, len);
            byte[] result = bo.toByteArray();
            bo.close();
            return result;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String convHexString(byte data) {
        String hex = Integer.toString(data, 16);
        if (hex.length() == 1) {
            hex = " 0" + hex;
        } else if (hex.length() == 2) {
            hex = " " + hex;
        }
        return hex;
    }

    public static String debugHex(byte[] data) {
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("[BINARY]");
        sb.append("================================================================");
        sb.append(line);
        sb.append(" 00  01  02  03  04  05  06  07  08  09  0A  0B  0C  0D  0E  0F");
        sb.append(line);
        sb.append("----------------------------------------------------------------");
        sb.append(line);
        int i = 0;
        while (i < data.length) {
            sb.append(String.valueOf(ByteUtil.convHexString(data[i])) + " ");
            if ((i + 1) % 16 == 0) {
                sb.append(line);
            }
            ++i;
        }
        sb.append(line);
        sb.append("================================================================");
        sb.append(line);
        return sb.toString();
    }

    public static String debugHex(String data) {
        return ByteUtil.debugHex(data.getBytes());
    }
}

