/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.threadpool;

import org.itscool.commons.threadpool.ClosedException;
import org.itscool.commons.threadpool.FIFOQueue;
import org.itscool.commons.threadpool.ThreadBufferException;
import org.itscool.commons.threadpool.WorkerThread;

public class ThreadPool {
    public static final int DEFAULT_MAX_THREADS = 10;
    private int maxThreads;
    private WorkerThread[] threadPool;
    private FIFOQueue workQueue;

    public ThreadPool(int maxthreadcount) {
        this.maxThreads = maxthreadcount;
        this.threadPool = new WorkerThread[this.maxThreads];
        this.workQueue = new FIFOQueue();
        this.initThreads();
    }

    public ThreadPool(int maxthreadcount, int maxbuffersize) {
        this.maxThreads = maxthreadcount;
        this.threadPool = new WorkerThread[this.maxThreads];
        this.workQueue = new FIFOQueue(maxbuffersize);
        this.initThreads();
    }

    public ThreadPool() {
        this(10, 100);
    }

    private void initThreads() {
        int i = 0;
        while (i < this.threadPool.length) {
            this.threadPool[i] = new WorkerThread(this.workQueue);
            ++i;
        }
    }

    public void addRequest(Runnable target) throws ClosedException, ThreadBufferException {
        try {
            this.workQueue.add(target);
        }
        catch (ClosedException ce) {
            throw ce;
        }
        catch (ThreadBufferException tbe) {
            throw tbe;
        }
    }

    public void close() {
        this.stopThreads();
        this.workQueue.close();
    }

    public int close(int waitTime) {
        this.close();
        int sleepTime = 1000;
        int waitCount = 0;
        int i = 0;
        while (sleepTime * i < waitTime) {
            if (this.workQueue.requestEmpty()) break;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        while (sleepTime * i < waitTime) {
            waitCount = 0;
            while (waitCount < this.threadPool.length) {
                if (!this.threadPool[waitCount].getWaitStatus()) break;
                ++waitCount;
            }
            if (waitCount >= this.threadPool.length) break;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        return waitCount;
    }

    private void stopThreads() {
        int i = 0;
        while (i < this.threadPool.length) {
            this.threadPool[i].setStopped();
            ++i;
        }
    }

    public void printStats() {
        System.out.println("Thread Usage ");
        int i = 0;
        while (i < this.threadPool.length) {
            System.out.println(this.threadPool[i].toString());
            ++i;
        }
    }
}

