/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.dao.DaoRuntimeException;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;

public class RecordMapFactory {
    public static final String COLUM = "COLUM_";
    public static final String PK_COLUM = "PK_COLUM_";
    public static final String TABLE = "TABLE";
    static /* synthetic */ Class class$0;

    public static RecordMap createRecordMap(String className) {
        try {
            Class<?> entity = Class.forName(className);
            return RecordMapFactory.create(entity);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RecordMap createRecordMap(Class entity) {
        return RecordMapFactory.create(entity);
    }

    private static RecordMap create(Class entity) {
        Object obj = BeanUtil.createInstance(entity.getName());
        String tableName = RecordMapFactory.getTableName(entity, obj, TABLE);
        RecordMap recordMap = new RecordMap(entity.getName(), tableName);
        recordMap = RecordMapFactory.create(entity, obj, recordMap);
        HashMap records = recordMap.getFields();
        Set keySet = records.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            try {
                Object key = iterator.next();
                FieldMap fieldMap = (FieldMap)records.get(key);
                Field field = BeanUtil.getField(entity, fieldMap.getPropertyName());
                String type = field.getType().getName();
                fieldMap.setType(type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recordMap;
    }

    private static RecordMap create(Class entity, Object obj, RecordMap recordMap) {
        Class superClazz = entity.getSuperclass();
        if (superClazz != null) {
            recordMap = RecordMapFactory.create(superClazz, obj, recordMap);
        }
        Field[] fields = entity.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            String staticName = field.getName();
            try {
                String propertyName;
                String fieldName;
                FieldMap fieldMap;
                int index = staticName.indexOf(COLUM);
                int pkIndex = staticName.indexOf(PK_COLUM);
                if (modifier == 25 && pkIndex == 0) {
                    fieldMap = new FieldMap();
                    fieldName = (String)field.get(obj);
                    propertyName = staticName.substring(PK_COLUM.length(), staticName.length());
                    fieldMap.setColumName(fieldName);
                    fieldMap.setPropertyName(propertyName);
                    fieldMap.setRecordMap(recordMap);
                    fieldMap.setPrimaryKey(true);
                    recordMap.addField(fieldMap);
                } else if (modifier == 25 && index == 0) {
                    fieldMap = new FieldMap();
                    fieldName = (String)field.get(obj);
                    propertyName = staticName.substring(COLUM.length(), staticName.length());
                    fieldMap.setColumName(fieldName);
                    fieldMap.setPropertyName(propertyName);
                    fieldMap.setRecordMap(recordMap);
                    fieldMap.setPrimaryKey(false);
                    recordMap.addField(fieldMap);
                }
            }
            catch (IllegalAccessException e) {
                StringBuffer stringBuffer = new StringBuffer("[").append(obj.getClass().getName()).append(":").append(staticName).append("]").append("create() failed(");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.itscool.commons.dao.RecordMapFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String err = stringBuffer.append(clazz.getName()).append(") (").append(e.getMessage()).append(")").toString();
                throw new DaoRuntimeException(err);
            }
            ++i;
        }
        return recordMap;
    }

    protected static String getTableName(Class entity, Object obj, String tableHeaderName) {
        String tableName = entity.getName();
        try {
            Field field = BeanUtil.getField(entity, tableHeaderName);
            if (field != null) {
                tableName = (String)field.get(obj);
            }
        }
        catch (Exception e) {
            tableName = entity.getName();
        }
        return tableName;
    }

    public static void testParseClass(Class clazz) throws Exception {
        System.out.println("---------------------------");
        RecordMap record = RecordMapFactory.createRecordMap(clazz);
        System.out.println(String.valueOf(record.getTableName()) + "," + record.getClassName());
        HashMap fields = record.getFields();
        Set keySet = fields.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            System.out.println(String.valueOf(fieldMap.getColumName()) + "," + fieldMap.getPropertyName() + "," + fieldMap.getType());
        }
    }
}

