package test.tutorial;

import org.itscool.weber.action.Globals;
import org.itscool.webertest.testcase.WeberTestCase;

import tutorial.HelloAction;
import tutorial.HelloBean;

/**
 * turorial.HelloActionNX̃eXgNX
 */
public class TestHelloAction extends WeberTestCase{
    
    /**
     * HelloAction.doExecute()eXg܂
     */
    public void testDoExcecute(){
        //ANV̐
        HelloAction action = new HelloAction();
        HelloBean bean = new HelloBean();
        
        bean.setAge(32);
        bean.setName("kano");
        
        try{
            //doExcecute\bh̃eXg{
            this.assertDoExecute(action, bean, "success");
            
            //doExecute()̎sʂmF
            HelloBean hello = (HelloBean)bucket.getAttribute("hello");
            assertEquals(hello.getName(), "KANO");
            assertEquals(hello.getAge(), 32);
            
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    /**
     * HelloAction.doValidate()eXg܂
     */
    public void testValidate(){
        HelloAction action = new HelloAction();
        request.addParameter("age", "32");
        request.addParameter("name", "kano");
        
        assertValidate(action, Globals.RET_SUCCESS);
    }
    
    /**
     * HelloAction.doValidate()eXg܂
     */
    public void testValidate2(){
        HelloAction action = new HelloAction();
        request.addParameter("age", "AAA");
        request.addParameter("name", "kano");
        
        assertValidate(action, Globals.REQ_PARAM_FORM_ERR);
    }
    
    /**
     * HelloAction.doValidate()eXg܂
     */
    public void testValidate3(){
        HelloAction action = new HelloAction();
        request.addParameter("age", "AAA");
        request.addParameter("name", null);
        
        assertValidate(action, Globals.REQ_PARAM_FORM_ERR);
    }
    
}

