/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.tagex;

import java.io.IOException;
import java.util.Calendar;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.itscool.commons.util.TagUtil;
import org.itscool.weber.tagex.CalendarTag;
import org.itscool.weber.tagex.DateElement;
import org.itscool.weber.tagex.MonthTable;

public class WeeklyCalendarTag
extends CalendarTag {
    protected void render() throws IOException, JspException {
        Calendar cal = null;
        MonthTable mTable = null;
        if (this.calendar != null && this.calendar.length() > 0) {
            cal = (Calendar)TagUtil.findObject((PageContext)this.pageContext, (String)this.calendar, (String)this.scope);
        }
        if (cal == null) {
            mTable = new MonthTable();
            cal = Calendar.getInstance();
            cal.set(1, mTable.getYear());
            cal.set(2, mTable.getMonth() - 1);
            cal.set(5, 1);
        } else {
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            mTable = new MonthTable(year, month);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<TABLE");
        int width = Integer.parseInt(this.celWidth);
        if (width > 0) {
            sb.append(" WIDTH=").append(width * 8 + 20);
        }
        sb.append(" border=1 cellSpacing=0 cellPadding=0 >");
        sb.append(LINE);
        DateElement date = mTable.getDay(mTable.getYear(), mTable.getMonth(), 1);
        cal.set(7, 1);
        int firstYear = cal.get(1);
        int firstMonth = cal.get(2) + 1;
        int firstDay = cal.get(5);
        sb.append("<TR HEIGHT=").append(26).append(">");
        sb.append(LINE);
        sb.append("    ").append("<TD ");
        sb.append(" ALIGN=").append(this.align);
        sb.append(" VALIGN=").append(this.valign);
        sb.append(" WIDTH=").append(width);
        sb.append(" STYLE=\"").append(this.dataStyle).append("\"");
        sb.append(">\u3000</TD>");
        sb.append(LINE);
        int i = 1;
        while (i <= 7) {
            date = mTable.getDay(cal);
            sb.append(this.createHeader(mTable, date));
            sb.append(LINE);
            ++i;
            cal.add(5, 1);
        }
        sb.append("</TR>").append(LINE);
        if (this.drawObj != null) {
            sb.append(this.drawObj.doPaint(mTable, firstYear, firstMonth, firstDay));
        }
        sb.append("</TABLE>");
        sb.append(LINE);
        this.pageContext.getOut().print(sb.toString());
    }

    protected String createHeader(MonthTable mTable, DateElement date) throws JspException {
        StringBuffer sb = new StringBuffer();
        StringBuffer td = new StringBuffer();
        td.append("    ");
        td.append("<TD ");
        td.append(" HEIGHT=20");
        td.append(" ALIGN=\"center\"");
        td.append(" VALIGN=\"center\"");
        if (date.isToday()) {
            td.append(" STYLE=").append(this.todayStyle);
        } else if (date.isHoliday()) {
            td.append(" STYLE=").append(this.holidayStyle);
        } else if (date.getYobi() == 1 || date.getYobi() == 7) {
            td.append(" STYLE=").append(this.donichiStyle);
        } else {
            td.append(" STYLE=").append(this.dataStyle);
        }
        td.append(">");
        sb.append(td.toString());
        sb.append(date.getDay());
        sb.append(" (").append(date.getYobiNa()).append(")");
        td.append(LINE).append("    ");
        sb.append("</TD>");
        sb.append(LINE);
        return sb.toString();
    }
}

