/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.tagex;

import java.io.IOException;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.commons.util.TagUtil;
import org.itscool.weber.tagex.DateElement;
import org.itscool.weber.tagex.DrawComponent;
import org.itscool.weber.tagex.MonthTable;

public class CalendarTag
extends TagSupport {
    protected static final String TAB = "    ";
    protected static final String LINE = System.getProperty("line.separator");
    protected String calendar;
    protected String celWidth = "10";
    protected String celHeight = "10";
    protected String align = "center";
    protected String valign = "center";
    protected String headerStyle = "\"FONT-SIZE:12;BACKGROUND:silver;\"";
    protected String dataStyle = "\"FONT-SIZE:12;BACKGROUND:white;\"";
    protected String donichiStyle = "\"FONT-SIZE:12;BACKGROUND:#FF99CC;\"";
    protected String holidayStyle = "\"FONT-SIZE:12;BACKGROUND:#FF99CC;\"";
    protected String todayStyle = "\"FONT-SIZE:12;BACKGROUND:#66FF33;\"";
    protected boolean enable = false;
    protected String path = "";
    protected String queryString = "";
    protected String queryParams = "";
    protected String scope;
    protected String paintClass;
    protected DrawComponent drawObj;

    public int doStartTag() throws JspException {
        try {
            if (this.paintClass != null && this.paintClass.length() > 0) {
                this.drawObj = (DrawComponent)BeanUtil.createInstance((String)this.paintClass);
                this.drawObj.setAlign(this.align);
                this.drawObj.setCelHeight(this.celHeight);
                this.drawObj.setCelWidth(this.celWidth);
                this.drawObj.setValign(this.valign);
                this.drawObj.setHeaderStyle(this.headerStyle);
                this.drawObj.setDataStyle(this.dataStyle);
                this.drawObj.setDonichiStyle(this.donichiStyle);
                this.drawObj.setHolidayStyle(this.holidayStyle);
                this.drawObj.setTodayStyle(this.todayStyle);
                this.drawObj.init(this.path, this.pageContext);
            }
            this.render();
        }
        catch (Exception e) {
            throw new JspException(e.getMessage());
        }
        return 0;
    }

    protected void render() throws IOException, JspException {
        int i;
        Calendar cal = null;
        MonthTable mTable = null;
        if (this.calendar != null && this.calendar.length() > 0) {
            cal = (Calendar)TagUtil.findObject((PageContext)this.pageContext, (String)this.calendar, (String)this.scope);
        }
        if (cal == null) {
            mTable = new MonthTable();
        } else {
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            mTable = new MonthTable(year, month);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<TABLE");
        int height = Integer.parseInt(this.celHeight);
        int width = Integer.parseInt(this.celWidth);
        if (height > 0) {
            sb.append(" HEIGHT=").append(height * 8 + 10);
        }
        if (width > 0) {
            sb.append(" WIDTH=").append(width * 7 + 10);
        }
        sb.append(" border=1 cellSpacing=0 cellPadding=0 >");
        sb.append(LINE);
        sb.append(this.createHeader());
        DateElement date = mTable.getDay(mTable.getYear(), mTable.getMonth(), 1);
        int firstYobi = date.getYobi();
        if (firstYobi != 1) {
            cal = DateFormatUtil.getLastMonthWeek((int)mTable.getYear(), (int)mTable.getMonth());
            i = 1;
            while (i < firstYobi) {
                date = mTable.getDay(cal);
                sb.append(this.createData(mTable, date));
                ++i;
                cal.add(5, 1);
            }
        }
        i = 0;
        while (i < mTable.getMaxday()) {
            date = mTable.getDay(mTable.getYear(), mTable.getMonth(), i + 1);
            sb.append(this.createData(mTable, date));
            ++i;
        }
        DateElement lastDay = mTable.getDay(mTable.getYear(), mTable.getMonth(), mTable.getMaxday());
        if (lastDay.getYobi() != 7) {
            cal = Calendar.getInstance();
            cal.set(1, mTable.getYear());
            cal.set(2, mTable.getMonth() - 1);
            cal.set(5, mTable.getMaxday());
            int i2 = lastDay.getYobi();
            while (i2 < 7) {
                date = mTable.getDay(cal);
                sb.append(this.createData(mTable, date));
                ++i2;
                cal.add(5, 1);
            }
        }
        sb.append("</TABLE>");
        this.pageContext.getOut().print(sb.toString());
    }

    protected String createHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("<TR HEIGHT=").append(this.celHeight).append(">");
        sb.append(LINE);
        StringBuffer td = new StringBuffer();
        td.append(TAB);
        td.append("<TD WIDTH=").append(this.celWidth);
        td.append(" ALIGN=").append("center");
        td.append(" STYLE=").append(this.headerStyle);
        td.append(">");
        sb.append(td.toString()).append("\u65e5").append("</TD>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u6708").append("</TD>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u706b").append("</TD>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u6c34").append("</TD>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u6728").append("</TD>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u91d1").append("</TD>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u571f").append("</TD>");
        sb.append(LINE);
        sb.append("</TR>").append(LINE);
        return sb.toString();
    }

    protected String createData(MonthTable mTable, DateElement date) throws JspException {
        StringBuffer sb = new StringBuffer();
        if (date.getYobi() == 1) {
            sb.append("<TR HEIGHT=").append(this.celHeight).append(">");
            sb.append(LINE);
        }
        StringBuffer td = new StringBuffer();
        td.append(TAB);
        td.append("<TD ");
        td.append(" ALIGN=").append(this.align);
        td.append(" VALIGN=").append(this.valign);
        if (date.isToday()) {
            td.append(" STYLE=").append(this.todayStyle);
        } else if (date.isHoliday()) {
            td.append(" STYLE=").append(this.holidayStyle);
        } else if (date.getYobi() == 1 || date.getYobi() == 7) {
            td.append(" STYLE=").append(this.donichiStyle);
        } else {
            td.append(" STYLE=").append(this.dataStyle);
        }
        td.append(">");
        sb.append(td.toString());
        if (this.enable && this.path != null && this.path.length() > 0) {
            sb.append(this.createHrefData(date));
        } else {
            sb.append(date.getDay());
            if (this.drawObj != null) {
                sb.append(this.drawObj.doPaint(date));
            }
        }
        td.append(LINE).append(TAB);
        sb.append("</TD>");
        sb.append(LINE);
        if (date.getYobi() == 7) {
            sb.append("</TR>").append(LINE);
        }
        return sb.toString();
    }

    protected String createHrefData(DateElement date) throws JspException {
        StringBuffer sb = new StringBuffer();
        sb.append(LINE).append(TAB).append(TAB);
        sb.append("<A HREF=\"").append(this.createPath(date)).append("\"");
        sb.append(">");
        sb.append(date.getDay());
        if (this.drawObj != null) {
            sb.append(this.drawObj.doPaint(date));
        }
        sb.append("</A>");
        return sb.toString();
    }

    protected String createPath(DateElement date) throws JspException {
        StringBuffer retPath = new StringBuffer();
        if (this.path.indexOf("/") != 0) {
            this.path = String.valueOf(this.path) + "/";
        }
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String queryParamStr = TagUtil.createQueryString((PageContext)this.pageContext, (String)this.queryParams, (String)this.scope);
        String contextPath = req.getContextPath();
        retPath.append(contextPath).append(this.path);
        if (queryParamStr != null && queryParamStr.length() > 0) {
            retPath.append(queryParamStr);
            retPath.append("&");
        } else {
            retPath.append("?");
        }
        if (this.queryString != null && this.queryString.length() > 0) {
            retPath.append(this.queryString);
            retPath.append("&");
        }
        retPath.append("year=").append(date.getYear());
        retPath.append("&month=").append(date.getMonth());
        retPath.append("&day=").append(date.getDay());
        if (this.queryString != null && this.queryString.length() > 0) {
            retPath.append("&").append(this.queryString);
        }
        return retPath.toString();
    }

    public int doEndTag() {
        return 6;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getCelHeight() {
        return this.celHeight;
    }

    public void setCelHeight(String celHeight) {
        this.celHeight = celHeight;
    }

    public String getCelWidth() {
        return this.celWidth;
    }

    public void setCelWidth(String celWidth) {
        this.celWidth = celWidth;
    }

    public String getDataStyle() {
        return this.dataStyle;
    }

    public void setDataStyle(String dataStyle) {
        this.dataStyle = dataStyle;
    }

    public String getDonichiStyle() {
        return this.donichiStyle;
    }

    public void setDonichiStyle(String donichiStyle) {
        this.donichiStyle = donichiStyle;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = headerStyle;
    }

    public String getHolidayStyle() {
        return this.holidayStyle;
    }

    public void setHolidayStyle(String holidayStyle) {
        this.holidayStyle = holidayStyle;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(String queryParams) {
        this.queryParams = queryParams;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getTodayStyle() {
        return this.todayStyle;
    }

    public void setTodayStyle(String todayStyle) {
        this.todayStyle = todayStyle;
    }

    public String getValign() {
        return this.valign;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public String getCalendar() {
        return this.calendar;
    }

    public void setCalendar(String calender) {
        this.calendar = calender;
    }

    protected String convertStrToNum(int number) {
        String ret = String.valueOf(number);
        if (number < 10) {
            ret = "0" + ret;
        }
        return ret;
    }

    public String getPaintClass() {
        return this.paintClass;
    }

    public void setPaintClass(String drawCellClass) {
        this.paintClass = drawCellClass;
    }
}

