/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.io;

import java.io.IOException;
import java.util.HashMap;
import org.itscool.commons.file.ConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageConfigReader
extends ConfigReader {
    protected void doCreate(HashMap hashMap) throws IOException {
        Node roles;
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at weber-message.xml(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList rolesList = root.getElementsByTagName("messages");
        if (rolesList != null && (roles = rolesList.item(0)) != null) {
            this.createMessages(roles, hashMap);
        }
    }

    protected void createMessages(Node roles, HashMap hashMap) {
        NodeList rolesChilds = roles.getChildNodes();
        int i = 0;
        while (i < rolesChilds.getLength()) {
            Node message = rolesChilds.item(i);
            if (message.getNodeName().equals("message")) {
                this.createMessage(message, hashMap);
            }
            ++i;
        }
    }

    protected void createMessage(Node message, HashMap hashMap) {
        NamedNodeMap attributes = message.getAttributes();
        Node key = attributes.getNamedItem("key");
        Node value = attributes.getNamedItem("value");
        hashMap.put(key.getNodeValue(), value.getNodeValue());
    }
}

