/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.file.Log;

public class TransactionFilter
implements Filter {
    private Log log = Log.getInstance();

    public void init(FilterConfig filterConfig) throws ServletException {
        BeanFactory factory = BeanFactory.getInstance();
        if (!factory.isInit()) {
            try {
                factory.createForUrl("di-config.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        try {
            this.log = (Log)factory.createInstance("Log");
        }
        catch (Exception ioe) {
            this.log.warn(ioe.getMessage());
        }
        try {
            ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
            manager.init();
            this.log.info("completed initialize instance='" + manager.getClass().getName() + "'");
            this.log.info("ConnectionManager Info=" + manager.toString());
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage());
            throw new ServletException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            try {
                TransactionUtil.beginTransaction();
                chain.doFilter(request, response);
                if (TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_COMMIT) {
                    TransactionUtil.commitTransaction();
                    this.log.debug("COMMIT TRANSACTION");
                } else if (TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_ROLLBACK) {
                    TransactionUtil.rollbackTransaction();
                    this.log.debug("ROLLBACK TRANSACTION");
                }
            }
            catch (IOException ioe) {
                TransactionUtil.rollbackTransaction();
                TransactionUtil.returnTransaction();
                this.log.debug("ROLLBACK TRANSACTION");
                throw ioe;
            }
            catch (ServletException se) {
                TransactionUtil.rollbackTransaction();
                TransactionUtil.returnTransaction();
                this.log.debug("ROLLBACK TRANSACTION");
                throw se;
            }
            catch (NullPointerException e) {
                TransactionUtil.rollbackTransaction();
                TransactionUtil.returnTransaction();
                this.log.debug("ROLLBACK TRANSACTION");
                throw new ServletException(e.getMessage());
            }
            catch (RuntimeException re) {
                TransactionUtil.rollbackTransaction();
                TransactionUtil.returnTransaction();
                this.log.debug("ROLLBACK TRANSACTION");
                throw new ServletException(re.getMessage());
            }
            catch (Exception e) {
                TransactionUtil.rollbackTransaction();
                TransactionUtil.returnTransaction();
                this.log.debug("ROLLBACK TRANSACTION");
                throw new ServletException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            TransactionUtil.returnTransaction();
            throw throwable;
        }
        {
            Object var5_11 = null;
        }
        TransactionUtil.returnTransaction();
    }

    public void destroy() {
        BeanFactory factory = BeanFactory.getInstance();
        ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
        manager.destroy();
    }
}

