/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.request;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.util.URLDecodeUtil;

public abstract class HttpGeneralForm
extends GeneralForm {
    private HashMap duplicateKeys = new HashMap();

    public void parseData(HttpServletRequest req, String encode) throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataInputStream dis = new DataInputStream((InputStream)req.getInputStream());
        boolean flag = true;
        while (flag) {
            try {
                byte b = dis.readByte();
                bao.write(b);
            }
            catch (EOFException e) {
                flag = false;
            }
        }
        if (bao.size() == 0) {
            this.doDefaultParseData(req, encode);
        } else {
            this.doParseData(bao.toByteArray(), encode);
        }
    }

    protected abstract void doParseData(byte[] var1, String var2);

    public void doDefaultParseData(HttpServletRequest req, String encode) throws IOException {
        Map pmap = req.getParameterMap();
        Set hset = pmap.keySet();
        Iterator iter = hset.iterator();
        int hno = hset.size();
        while (iter.hasNext()) {
            String value;
            String name = (String)iter.next();
            String[] values = (String[])pmap.get(name);
            if (values.length == 1) {
                try {
                    value = values[0];
                    value = URLDecodeUtil.decode(value, encode);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                this.addParameter(name, (Object)value);
                continue;
            }
            int i = 0;
            while (i < values.length) {
                value = values[i];
                this.addParameter(name, (Object)value);
                ++i;
            }
        }
        this.margeParamsByDuplicateKey();
    }

    public void addParameter(String key, Object obj) {
        Object chkObj;
        int index = key.indexOf(".");
        if (index != -1) {
            key = key.substring(0, index);
        }
        if ((chkObj = this.getParameter(key)) != null) {
            ArrayList<Object> duplicateParams = (ArrayList<Object>)this.duplicateKeys.get(key);
            if (duplicateParams == null) {
                duplicateParams = new ArrayList<Object>();
                this.duplicateKeys.put(key, duplicateParams);
                duplicateParams.add(chkObj);
            }
            duplicateParams.add(obj);
        }
        super.addParameter(key, obj);
    }

    protected void margeParamsByDuplicateKey() {
        Set keySet = this.duplicateKeys.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            List paramList = (List)this.duplicateKeys.get(paramName);
            super.removeParameter(paramName);
            super.addParameter(paramName, paramList);
        }
    }
}

