/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class PropertyFile {
    public static final String PROPERTIES_COMMENT_KEY = "#";
    protected Hashtable dataList = new Hashtable();
    private String path;
    private String commentKey;

    public PropertyFile(String path) throws IOException {
        this.path = path;
        this.commentKey = PROPERTIES_COMMENT_KEY;
        this.load();
    }

    public void load() throws IOException {
        String buff = this.commentKey;
        FileReader frIn = null;
        try {
            frIn = new FileReader(this.path);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        BufferedReader brIn = new BufferedReader(frIn);
        this.dataList.clear();
        while (buff != null) {
            int index;
            buff = brIn.readLine();
            if (buff == null || buff.startsWith(this.commentKey, 0) || (index = buff.indexOf("=")) == -1) continue;
            String key = buff.substring(0, index);
            key = key.trim();
            String data = buff.substring(index + 1);
            data = data.trim();
            this.dataList.put(key, data);
        }
        frIn.close();
        brIn.close();
    }

    public String read(String key) {
        String data = (String)this.dataList.get(key);
        return data;
    }

    public boolean write(String key, String data, boolean append) throws IOException {
        if (this.read(key) != null) {
            return false;
        }
        if (!append) {
            this.dataList.clear();
        }
        this.dataList.put(key, data);
        this.out(key, data, append);
        return true;
    }

    protected synchronized void out(String key, String data, boolean append) throws IOException {
        FileOutputStream out = new FileOutputStream(this.path, append);
        String line = System.getProperty("line.separator");
        out.write(key.getBytes());
        out.write(new String(" = ").getBytes());
        out.write(data.getBytes());
        out.write(line.getBytes());
        out.close();
    }

    public boolean delete(String delKey) throws IOException {
        if (!this.isFile(this.path)) {
            return false;
        }
        this.load();
        if (this.dataList.get(delKey) != null) {
            this.dataList.remove(delKey);
            this.upFile();
        }
        return true;
    }

    public void removeAll() {
        if (this.isFile(this.path)) {
            this.delFile(this.path);
        }
        this.dataList.clear();
    }

    protected void upFile() throws IOException {
        if (this.dataList.size() == 0) {
            this.delFile(this.path);
        } else {
            Enumeration enumObj = this.dataList.keys();
            while (enumObj.hasMoreElements()) {
                String key = (String)enumObj.nextElement();
                String data = this.read(key);
                this.out(key, data, true);
            }
        }
    }

    protected boolean isFile(String path) {
        File file = new File(path);
        return file.canRead();
    }

    protected synchronized void delFile(String path) {
        File file = new File(path);
        file.delete();
    }

    public int size() {
        return this.dataList.size();
    }

    public String toString() {
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        Enumeration enumObj = this.dataList.keys();
        while (enumObj.hasMoreElements()) {
            String key = (String)enumObj.nextElement();
            String data = (String)this.dataList.get(key);
            sb.append("[KEY-->" + key + "] [DATA--->" + data);
            sb.append(line);
        }
        return sb.toString();
    }

    public Hashtable getDataList() {
        return this.dataList;
    }
}

