/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.file;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.itscool.commons.file.Log;
import org.itscool.commons.file.MyHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class ConfigReader {
    protected Log log = Log.getInstance();
    protected File xmlFile;
    protected DocumentBuilderFactory factory;
    protected DocumentBuilder builder;
    protected Document document;
    protected String configName;
    static /* synthetic */ Class class$0;

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void create(HashMap nodeList) throws IOException {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL url = parent.getResource(this.configName);
        if (url == null) {
            throw new IOException(String.valueOf(this.configName) + " is not found.");
        }
        this.log.info("load config is " + url.getFile());
        this.create(url.getFile(), nodeList);
    }

    public void create(LinkedList nodeList) throws IOException {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL url = parent.getResource(this.configName);
        if (url == null) {
            throw new IOException(String.valueOf(this.configName) + " is not found.");
        }
        this.log.info("load config is " + url.getFile());
        this.create(url.getPath(), nodeList);
    }

    public void create(String path, HashMap nodeList) throws IOException {
        File xmlFile = new File(path);
        if (!xmlFile.isFile()) {
            String err = "Can not found file at config file(" + path + ")";
            throw new IOException(err);
        }
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
            this.builder.setErrorHandler(new MyHandler());
            this.document = this.builder.parse(xmlFile);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.doCreate(nodeList);
    }

    public void create(String path, LinkedList nodeList) throws IOException {
        File xmlFile = new File(path);
        if (!xmlFile.isFile()) {
            StringBuffer stringBuffer = new StringBuffer("[").append(path).append("]").append("Can not found file  at config file(");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.itscool.commons.file.ConfigReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String err = stringBuffer.append(clazz.getName()).append(")").toString();
            throw new IOException(err);
        }
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
            this.builder.setErrorHandler(new MyHandler());
            this.document = this.builder.parse(xmlFile);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.doCreate(nodeList);
    }

    protected void doCreate(HashMap nodeList) throws IOException {
    }

    protected void doCreate(LinkedList nodeList) throws IOException {
    }
}

