/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.file;

import java.io.File;
import java.util.Calendar;

public abstract class AbstractLog {
    public static final String DEBUG = "debug";
    public static final String INFO = "info";
    public static final String WARN = "warn";
    public static final String ERROR = "error";
    public static final String SYSTEM = "system";
    public static final String DISP_MODE = "disp";
    public static final String FILE_MODE = "file";
    public static final String ALLOUT_MODE = "all";
    protected int maxSize;
    protected String logPath;
    protected String level = "debug";
    protected int levelInt = 0;
    protected String mode = "disp";
    protected String encode;

    public String getLevel() {
        return this.level;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getMode() {
        return this.mode;
    }

    public void debug(String msg) {
        this.out(msg, DEBUG);
    }

    public void info(String msg) {
        this.out(msg, INFO);
    }

    public void warn(String msg) {
        this.out(msg, WARN);
    }

    public void error(String msg) {
        this.out(msg, ERROR);
    }

    public void faital(String msg) {
        this.out(msg, SYSTEM);
    }

    public abstract void out(String var1, String var2);

    public static String getLogKind(String levelNow) {
        if (levelNow.equals(DEBUG)) {
            return "DEBUG";
        }
        if (levelNow.equals(INFO)) {
            return "INFO ";
        }
        if (levelNow.equals(WARN)) {
            return "WORN ";
        }
        if (levelNow.equals(ERROR)) {
            return "ERROR";
        }
        if (levelNow.equals(SYSTEM)) {
            return "SYSTEM";
        }
        return "DEBUG";
    }

    public static String getLogMode(String mode) {
        if (mode.equals(DISP_MODE)) {
            return "DISP ONLY";
        }
        if (mode.equals(FILE_MODE)) {
            return "FILE ONLY";
        }
        return "DISP & FILE ";
    }

    protected static String getNowDate() {
        Calendar date = Calendar.getInstance();
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = date.get(10);
        int minute = date.get(12);
        int second = date.get(13);
        String monthPadding = "";
        String dayPadding = "";
        String hourPadding = "";
        String minutePadding = "";
        String secondPadding = "";
        if (month < 10) {
            monthPadding = "0";
        }
        if (day < 10) {
            dayPadding = "0";
        }
        if (hour < 10) {
            hourPadding = "0";
        }
        if (minute < 10) {
            minutePadding = "0";
        }
        if (second < 10) {
            secondPadding = "0";
        }
        StringBuffer ret = new StringBuffer();
        ret.append(year).append("/");
        ret.append(monthPadding).append(month).append("/");
        ret.append(dayPadding).append(day).append(" ");
        ret.append(hourPadding).append(hour).append(":");
        ret.append(minutePadding).append(minute).append(":");
        ret.append(secondPadding).append(second);
        return ret.toString();
    }

    protected static String getNowDateYYYYMMDDHHMMSS() {
        Calendar date = Calendar.getInstance();
        String year = String.valueOf(date.get(1));
        String month = String.valueOf(date.get(2));
        String day = String.valueOf(date.get(5));
        String hour = String.valueOf(date.get(10));
        String minute = String.valueOf(date.get(12));
        String second = String.valueOf(date.get(13));
        return String.valueOf(year) + month + day + hour + minute + second;
    }

    protected synchronized void sizeCheck() {
        File file = new File(this.logPath);
        if (file.canRead() && file.length() >= (long)(this.maxSize * 1024)) {
            file.renameTo(new File(String.valueOf(this.logPath) + "." + AbstractLog.getNowDateYYYYMMDDHHMMSS()));
        }
        file = null;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public void setLevel(String level) {
        this.level = level;
        this.levelInt = this.getLevelNum(level);
    }

    protected int getLevelNum(String level) {
        this.level = level;
        if (level.equals(DEBUG)) {
            return 0;
        }
        if (level.equals(INFO)) {
            return 1;
        }
        if (level.equals(WARN)) {
            return 2;
        }
        if (level.equals(ERROR)) {
            return 3;
        }
        if (level.equals(SYSTEM)) {
            return 4;
        }
        return 0;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

