/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.daotool.data;

import org.apache.poi.hssf.usermodel.HSSFCell;

public class CellUtil {
    public static String getStringCellValue(HSSFCell cell) {
        String value = "";
        if (cell == null) {
            return value;
        }
        if (cell.getCellType() == 1) {
            value = cell.getStringCellValue();
        } else if (cell.getCellType() == 0) {
            value = String.valueOf(cell.getNumericCellValue());
        } else if (cell.getCellType() == 4) {
            value = String.valueOf(cell.getNumericCellValue());
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static double getNumericCellValue(HSSFCell cell) {
        double value = -1.0;
        if (cell == null) {
            return value;
        }
        if (cell.getCellType() == 1) {
            try {
                value = Double.valueOf(cell.getStringCellValue());
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        } else if (cell.getCellType() == 0) {
            value = cell.getNumericCellValue();
        }
        return value;
    }

    public static boolean getBooleanCellValue(HSSFCell cell) {
        boolean value = false;
        if (cell == null) {
            return value;
        }
        if (cell.getCellType() == 1) {
            String strValue = cell.getStringCellValue().trim();
            value = (strValue = strValue.toLowerCase()).equals("true");
        } else if (cell.getCellType() == 0) {
            int intValue = (int)cell.getNumericCellValue();
            value = intValue > 0;
        } else if (cell.getCellType() == 4) {
            value = cell.getBooleanCellValue();
        }
        return value;
    }
}

