/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.bean;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.bean.BeanConfigReader;
import org.itscool.commons.bean.BeanFactoryRuntimeException;
import org.itscool.commons.bean.BeanInfoMapping;
import org.itscool.commons.bean.BeanPropertyInfo;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.file.Log;

public class BeanFactory {
    private static BeanFactory instance = new BeanFactory();
    private HashMap beanMap = new HashMap();
    private BeanConfigReader reader = new BeanConfigReader();
    private boolean initFlg = false;
    private Log log = Log.getInstance();
    static /* synthetic */ Class class$0;

    public boolean isInit() {
        return this.initFlg;
    }

    public static BeanFactory getInstance() {
        return instance;
    }

    public void createForUrl(String configName) throws IOException {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL diconfigUrl = parent.getResource(configName);
        try {
            if (diconfigUrl == null) {
                throw new IOException(String.valueOf(configName) + "\u3078\u306e\u30d1\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            }
            String configFwName = diconfigUrl.getPath();
            this.create(configFwName);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage());
            throw new IOException(ex.getMessage());
        }
    }

    public void create(String[] pathList) throws IOException {
        String path = new String("");
        try {
            int i = 0;
            while (i < pathList.length) {
                path = pathList[i];
                this.reader.create(path, this.beanMap);
                ++i;
            }
        }
        catch (IOException ioe) {
            this.log.error(ioe.getMessage());
            throw new IOException(String.valueOf(ioe.getMessage()) + "[" + path + "]");
        }
    }

    public void create(String path) throws IOException {
        this.reader.create(path, this.beanMap);
        this.initFlg = true;
        this.log.info("completed initialize config='" + path + "'");
    }

    public Object createInstance(String id) {
        BeanInfoMapping beanInfo = (BeanInfoMapping)this.beanMap.get(id);
        Object obj = null;
        if (beanInfo == null) {
            String msg = String.valueOf(this.getClass().getName()) + " not found[" + id + "]";
            throw new BeanFactoryRuntimeException(msg);
        }
        obj = this.createInstance(beanInfo);
        return obj;
    }

    public Object createInstance(BeanInfoMapping beanInfo) {
        Object obj = null;
        if (beanInfo.getSingleton()) {
            obj = BeanUtil.getInstance(beanInfo.getType());
        } else if (beanInfo.getValue() != null) {
            String[] argTypes = new String[1];
            Object[] argValues = new String[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            argTypes[0] = clazz.getName();
            argValues[0] = beanInfo.getValue();
            obj = BeanUtil.createInstance(beanInfo.getType(), argTypes, argValues);
        } else {
            obj = BeanUtil.createInstance(beanInfo.getType());
        }
        HashMap pMap = beanInfo.getProperties();
        if (pMap == null) {
            return obj;
        }
        Set pKeySet = pMap.keySet();
        Iterator pIt = pKeySet.iterator();
        while (pIt.hasNext()) {
            String pKey = (String)pIt.next();
            BeanPropertyInfo propertyInfo = (BeanPropertyInfo)pMap.get(pKey);
            String ref = propertyInfo.getRef();
            String collection = propertyInfo.getCollection();
            if (collection != null) {
                Object colObj = this.createCollection(propertyInfo);
                BeanUtil.setProperty(obj, propertyInfo.getName(), colObj);
                continue;
            }
            if (ref != null) {
                Object refObj = this.createInstance(ref);
                BeanUtil.setProperty(obj, propertyInfo.getName(), refObj);
                continue;
            }
            if (propertyInfo.getValue() != null) {
                BeanUtil.setProperty(obj, propertyInfo.getName(), propertyInfo.getValue());
                continue;
            }
            String msg = String.valueOf(this.getClass().getName()) + " not found property[" + pKey + "]";
            this.log.warn(msg);
        }
        this.log.debug(String.valueOf(beanInfo.getType()) + " is created instance.");
        return obj;
    }

    protected Object createCollection(BeanPropertyInfo propertyInfo) {
        HashMap attrList = propertyInfo.getAttrList();
        Set set = attrList.keySet();
        Iterator it = set.iterator();
        String collection = propertyInfo.getCollection();
        if (collection.equals("map")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (it.hasNext()) {
                Object key = it.next();
                BeanInfoMapping childBeanInfo = (BeanInfoMapping)attrList.get(key);
                Object chldObj = this.createInstance(childBeanInfo);
                map.put(childBeanInfo.getId(), chldObj);
            }
            return map;
        }
        if (collection.equals("list")) {
            ArrayList<Object> lst = new ArrayList<Object>();
            while (it.hasNext()) {
                Object key = it.next();
                BeanInfoMapping childBeanInfo = (BeanInfoMapping)attrList.get(key);
                Object chldObj = this.createInstance(childBeanInfo);
                lst.add(chldObj);
            }
            return lst;
        }
        String msg = String.valueOf(this.getClass().getName()) + " not found collection kind.[" + collection + "]";
        this.log.warn(msg);
        return null;
    }
}

