/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.webertest.testcase;

import junit.framework.TestCase;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.file.Log;
import org.itscool.commons.request.GeneralForm;
import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.user.User;
import org.itscool.webertest.mock.MockActionBucket;
import org.itscool.webertest.mock.MockGeneralForm;

public abstract class WeberTestCase
extends TestCase {
    protected Log log = Log.getInstance();
    protected BeanFactory factory = BeanFactory.getInstance();
    protected MockActionBucket bucket = new MockActionBucket();
    protected MockGeneralForm request = new MockGeneralForm();

    public void assertDoExecute(Action action, Object form, String forward) {
        this.bucket.setForm(form);
        action.setGeneralForm((GeneralForm)this.request);
        String result = "";
        try {
            result = action.doExecute((ActionBucket)this.bucket);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            WeberTestCase.fail((String)e.getMessage());
        }
        WeberTestCase.assertEquals((String)forward, (String)result);
    }

    public void assertCheckUserRole(Action action, User user, boolean ret) {
        action.setGeneralForm((GeneralForm)this.request);
        this.bucket.setAttributeFromSession("org.itscool.weber.action.USER", user);
        try {
            boolean isUser = action.checkUserRole((ActionBucket)this.bucket);
            WeberTestCase.assertEquals((boolean)ret, (boolean)isUser);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            WeberTestCase.fail((String)e.getMessage());
        }
    }

    public void assertValidate(Action action, String forward) {
        action.setGeneralForm((GeneralForm)this.request);
        try {
            String ret = action.validate((ActionBucket)this.bucket);
            WeberTestCase.assertEquals((String)forward, (String)ret);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            WeberTestCase.fail((String)e.getMessage());
        }
    }
}

