package org.itscool.webertest.testcase;

import java.net.URL;
import java.util.LinkedList;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.action.Action;
import org.itscool.weber.user.User;
import org.itscool.webertest.io.DbTestConfigReader;
import org.itscool.webertest.mapping.FieldData;
import org.itscool.webertest.mapping.RecordData;
import org.itscool.webertest.mapping.TableData;

/**
 * f[^x[X̒P̃eXg@\geXgNXł
 * 
 * @author kano
 * @version 1.00A 2006/01/31 VK쐬
 */
public abstract class WeberDbTestCase extends WeberTestCase{
	/** ConnectionManagerCX^X */
	protected ConnectionManager mgr;
	/** eXgf[^`t@Ci[XgNX */
	protected static LinkedList testDataList = new LinkedList();
	
	private static boolean initFlg = false;
    
    public WeberDbTestCase(){
		super();
    	if(!initFlg){
    		init();
    		initFlg = true;
    	}
    }
    
	/**
	 * eXgŜʂ1񂾂s鏉֐
	*/
	public void init(){
		try{
			ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
    	    URL diconfigUrl = parent.getResource("di-config.xml");
    	    
    	    String configFwName;
    	    //System.out.println("di-config.xml path use = " + diconfigUrl.getPath());
    	    if(diconfigUrl == null ){
    	    	String err = "di-config.xml path is null.";
    	    	fail(err);
    	    	log.error(err);
    	    	return;
    	    }else{
    	    	configFwName = diconfigUrl.getPath();
    	    }
        	BeanFactory factory = BeanFactory.getInstance();
        	factory.create(configFwName);
        	mgr = (ConnectionManager) factory.createInstance("ConnectionManager");
			mgr.init();
    	}catch(Exception e){
    		log.error(e.getMessage());
    		fail(e.getMessage());
    		mgr.destroy();
    	}
    }
	
    public void tearDown(){
    	TransactionUtil.returnTransaction();
    }
	
	/**
	 * eXgf[^쐬܂
	 * @param configPath eXgf[^`t@C̃pX(AvP[V
	 * sfBNg̑΃pXjw肵܂
	 */
	public void initTables(String configName){
		//ClassLoader parent = ClassLoader.getSystemClassLoader();
	    //ClassLoader parent = filterConfig.getClass().getClassLoader();
	    ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
	    URL configUrl = parent.getResource(configName);
	    
		//DB`񃍁[h
		String path = configUrl.getPath();
    	
    	DbTestConfigReader dbReader = new DbTestConfigReader();
    	try{
    		testDataList.clear();
    		dbReader.create(path, testDataList);
    		//test.initTables();
    		clearTables();
    		insertDatas();
    	}catch(Exception e){
    		log.error(e.getMessage());
    		fail(e.getMessage());
    	}
    	
	}
	
	/**
	 * SẴeXgf[^폜܂
	 * @throws Exception
	 */
	protected void clearTables(){
		Transaction transaction = TransactionUtil.getTransaction();
		if( testDataList.size() == 0 ) return;
		
		System.out.println("---- delete data start --- ");
		
		try{
			for(int i=testDataList.size(); i>0; i--){
				TableData table = (TableData)testDataList.get(i-1);
				StringBuffer sql = new StringBuffer("Delete From ");
				sql.append(table.getTableName());
				System.out.println(sql.toString());
				transaction.execute(sql.toString());
				TransactionUtil.commitTransaction();
			}
		}catch(Exception e){
			log.error(e.getMessage() + ", Execute role back.");
			TransactionUtil.rollbackTransaction();
			fail(e.getMessage());
		}finally{
			TransactionUtil.returnTransaction();
		}
		
		System.out.println("---- delete data end --- ");
		
	}
	
	/**
	 * eXgf[^f[^x[Xɑ}܂
	 * @throws Exception
	 */
	protected void insertDatas(){
		Transaction transaction = TransactionUtil.getTransaction();
		
		System.out.println("---- insert data start --- ");
		try{
			for(int i=0; i<testDataList.size(); i++){
				TableData table = (TableData)testDataList.get(i);
				for( int j=0; j<table.getRecordSize(); j++ ){
					RecordData record = (RecordData)table.getRecordData(j);
					StringBuffer sql = new StringBuffer("Insert Into ");
					sql.append(table.getTableName());
					sql.append(" ( ");
					
					//INSERT INTO e[u ( ,  ,.......)
				    //   VALUES(f[^ , f[^ ,.......);
					if(record.getFieldSize() == 0 ){
						continue;
					}
					for(int k=0; k<record.getFieldSize(); k++){
						FieldData field = (FieldData)record.getFieldData(k);
						sql.append(field.getName());
						if( (k+1)<record.getFieldSize()){
							sql.append(", ");
						}
					}
					sql.append(" ) Values ( ");
					for(int k=0; k<record.getFieldSize(); k++){
						FieldData field = (FieldData)record.getFieldData(k);
						sql.append(field.getValue());
						if( (k+1)<record.getFieldSize()){
							sql.append(", ");
						}
					}
					sql.append(" )");
					System.out.println(sql.toString());
					transaction.execute(sql.toString());
				}
			}
			
			TransactionUtil.commitTransaction();
		}catch(Exception e){
			log.error(e.getMessage() + ", Execute role back.");
			TransactionUtil.rollbackTransaction();
			fail(e.getMessage());
		}finally{
			TransactionUtil.returnTransaction();
		}
		System.out.println("---- insert data end --- ");
		
	}
	
	/**
     * ANVdoExecute\bh؂܂B<BR>
     * f[^x[X̍XVsꂽꍇ̓R~bg/[obNs܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    public void assertDoExecute(Action action, Object form, String forward){
    	super.assertDoExecute(action, form, forward);
    	int trnStatus = TransactionUtil.getTransaction().getTranStatus();
    	if( trnStatus == Transaction.PLEASE_COMMIT ){
    		TransactionUtil.commitTransaction();
    	}else if( trnStatus == Transaction.PLEASE_ROLLBACK ){
    		TransactionUtil.rollbackTransaction();
    	}
    }
    
    /**
     * ANVcheckUserRole\bh؂܂B<BR>
     * f[^x[X̍XVsꂽꍇ̓R~bg/[obNs܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    public void assertCheckUserRole(Action action, User user, boolean ret){
        super.assertCheckUserRole(action, user, ret);
        int trnStatus = TransactionUtil.getTransaction().getTranStatus();
    	if( trnStatus == Transaction.PLEASE_COMMIT ){
    		TransactionUtil.commitTransaction();
    	}else if( trnStatus == Transaction.PLEASE_ROLLBACK ){
    		TransactionUtil.rollbackTransaction();
    	}
    }
    
    /**
     * ANVvalidate\bh؂܂B<BR>
     * f[^x[X̍XVsꂽꍇ̓R~bg/[obNs܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    public void assertValidate(Action action, String forward){
        super.assertValidate(action, forward);
        int trnStatus = TransactionUtil.getTransaction().getTranStatus();
    	if( trnStatus == Transaction.PLEASE_COMMIT ){
    		TransactionUtil.commitTransaction();
    	}else if( trnStatus == Transaction.PLEASE_ROLLBACK ){
    		TransactionUtil.rollbackTransaction();
    	}
    }
}
