package org.itscool.webertest.io;

import java.io.IOException;
import java.util.HashMap;

import org.itscool.commons.file.ConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * web.xml&lt;init-param&gt;vf͂NXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class WebReader extends ConfigReader{
    /**
     * XMLt@C&lt;action-mappings&gt;vf͂܂<br>
     * ͌ʂhashMapɃZbg܂<br>
     * @param hashMap XML̉͌
    */
    protected void doCreate(HashMap hashMap) throws IOException{
        
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at web.xml(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        
        NodeList filterList = root.getElementsByTagName("filter");
        if( filterList != null ){
        	for(int i=0; i<filterList.getLength(); i++){
        		Node filter = filterList.item(i);
        		createInitParams(filter, hashMap);
        	}
        }
        
        NodeList servletList = root.getElementsByTagName("servlet");
        if( servletList != null ){
        	for(int i=0; i<servletList.getLength(); i++){
        		Node servlet = servletList.item(i);
        		createInitParams(servlet, hashMap);
        	}
        }
    }
    /**
     * &lt;action-mappings&gt;vf͂܂
     * @param mappings &lt;action-mappings&gt;vf
     * @param hashMap ͌&lt;action&gt;ǉm[hXg
     * @throws Exception
     */
    protected void createInitParams(Node mappings, HashMap hashMap)
    throws IOException{
    	NodeList mappingChilds = mappings.getChildNodes();
        
        for( int i = 0; i < mappingChilds.getLength(); i++) {
            Node initParam = mappingChilds.item(i);
            
            if( initParam.getNodeName().equals("init-param")){
            	createInitParam(initParam, hashMap);
            }
        }
        
    }
    
    protected void createInitParam(Node initParam, HashMap hashMap){
    	NodeList initParamChilds = initParam.getChildNodes();
    	String name = null;
    	String value = null;
    	
    	for( int i = 0; i < initParamChilds.getLength(); i++) {
    		Node param = initParamChilds.item(i);
    		if(param.getNodeName().equals("param-name")){
    			Node nameBody = param.getFirstChild();
    			if(nameBody != null){
    				name = nameBody.toString();
    			}
    		}else if(param.getNodeName().equals("param-value")){
    			Node valueBody = param.getFirstChild();
    			if( valueBody != null){
    				value = valueBody.toString();
    			}
    		}
    	}
    	if( name != null && value != null){
    		hashMap.put(name, value);
    	}
    }
}
