package org.itscool.weber.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.itscool.commons.file.HexPropertyFile;
import org.itscool.commons.util.AngouUtil;

/**
 * ǗNXł<BR>
 * ̃t[[Nł́AActionɑ΂ČɂANZXRg[
 * @\Ă܂B<br>
 * RoleManager͂炩ߒ`ꂽ[UɃNCAgvꂽ
 * Actionꂽ[Uł邩肵܂<br>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
*/
public class RoleFileManager implements RoleManager{
	private HashMap roleDefines = new HashMap();
	private String rootPath;
    /** t@C̃Xg */
    private HashMap roleFiles;
    /** BRoleManagerCX^X */
    private static RoleFileManager instance = null;
    
    /**
     * RoleManagerCX^X擾܂
     * @return RoleMangerCX^Xԋp܂
    */
    public static RoleFileManager getInstance(){
        if( instance == null ){
            instance = new RoleFileManager();
        }
        return instance;
    }
    
    /**
     * RoleManagerCX^X܂
    */
    private RoleFileManager(){
        roleFiles = new HashMap();
    }
    
    public void init() throws IOException{
    	Set keySet = roleDefines.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
        	String roleName = (String)it.next();
        	String roleFileName = (String)roleDefines.get(roleName);
        	String roleFilePath = rootPath + roleFileName;
    	    
        	UserRole role = new UserRole();
        	role.setName((String)roleName);
        	
        	HexPropertyFile roleFile = new HexPropertyFile(roleFilePath);
            roleFiles.put( roleName, roleFile );
        }
        
    }
    
    /**
     * w肳ꂽ[UANZXĂ邩肵܂<BR>
     * ÍꂽpX[hAngouNXɂĕ܂
     * @param roles 񃊃Xg
     * @param user [U
     * @return ̃[UɂANZXĂꍇtrueԂ܂
    */
    public boolean isUserCheck(HashMap roles, User user ) {
    	if( user == null ){
    		return false;
    	}
        if( roles == null || roles.size() == 0 ){
        	return isRoles(user);
        }else{
        	return isRoles(roles, user);
        }
    }
    
    /**
     * pX[ht@C̍ēǂݍ݂s܂B
    */
    public void reload() {
        Set keySet = roleFiles.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            String roleName = (String)it.next();
            HexPropertyFile roleFile = (HexPropertyFile)roleFiles.get(roleName);
            if(roleFile == null ){
    			throw new RuntimeException("file not found for roleName[" + roleName + "]");
    		}
            try{
            	roleFile.load();
            }catch( IOException ioe ){}
        }
    }
    
    public List getAllData(){
    	List users = new ArrayList();
    	Set keySet = roleFiles.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            String roleName = (String)it.next();
            HexPropertyFile roleFile = (HexPropertyFile)roleFiles.get(roleName);
            Hashtable dataList = roleFile.getDataList();
    		
    		for( Enumeration enumObj = dataList.keys();
            enumObj.hasMoreElements(); ){
                String userName = ( String )enumObj.nextElement();
                byte[] pwd    =  (byte[])dataList.get(userName);
                String pwdStr = "";
                try{
                    pwdStr = AngouUtil.decrypt(userName, pwd );
                }catch( Exception e ){
                    throw new RuntimeException(e.getMessage());
                }
                User user = new User();
        		user.setName(userName);
        		user.setPwd(pwdStr);
        		users.add(user);
            }
        }
    	return users;
    }
    
    /**
	 * w肳ꂽ̃[U擾܂
	 * @param roleName 
	 * @param userName [U
	 * @return User [U
	 */
	public User getUser(String roleName, String userName){
		HexPropertyFile roleFile = (HexPropertyFile)roleFiles.get(roleName);
		if(roleFile == null ){
			throw new RuntimeException("file not found for roleName[" + roleName + "]");
		}
		byte[] pwd = roleFile.readHex(userName);
		String pwdStr = "";
		try{
            pwdStr = AngouUtil.decrypt(userName, pwd );
        }catch( Exception e ){
            throw new RuntimeException(e.getMessage());
        }
		User user = new User();
		user.setName(userName);
		user.setPwd(pwdStr);
		
		UserRole userRole = new UserRole();
		userRole.setName(roleName);
		user.setRole(userRole);
		
		return user;
	}
	
	/**
	 * w肳ꂽz̃[UXg擾܂
	 * @param roleName 
	 * @return HashMap UserCX^X̔zԂ܂B
	 */
	public HashMap getUsers(String roleName){
		HexPropertyFile pFile = (HexPropertyFile)roleFiles.get(roleName);
		Hashtable dataList = pFile.getDataList();
		HashMap users = new HashMap();
		
		for( Enumeration enumObj = dataList.keys();
        enumObj.hasMoreElements(); ){
            String userName = ( String )enumObj.nextElement();
            byte[] pwd    =  (byte[])dataList.get(userName);
            String pwdStr = "";
            try{
                pwdStr = AngouUtil.decrypt(userName, pwd );
            }catch( Exception e ){
                throw new RuntimeException(e.getMessage());
            }
            User user = new User();
    		user.setName(userName);
    		user.setPwd(pwdStr);
    		users.put(userName, user);
        }
        return users;
	}
	
	/**
     * w肳ꂽ[U폜܂
     * @param roleName [
     * @param name [U
     * @throws IOException
     */
    public void delete(String roleName, String name) throws IOException{
    	User user = new User();
    	user.setName(name);
    	delete(roleName, user);
    }

    /**
     * f[^폜܂
     * @param roleName 
     * @param user [U
    */
    public synchronized void delete(String roleName, User user)
    throws IOException{
        String userName = user.getName();
        HexPropertyFile roleFile = (HexPropertyFile)roleFiles.get(roleName);
        if(roleFile == null ){
			throw new RuntimeException("file not found for roleName[" + roleName + "]");
		}
        roleFile.delete(userName);
        reload();
    }
    
	/**
	 * Ƀ[Uǉ܂
     * @param roleName 
     * @param user [U
     * @return boolean [U̓o^ɐꍇtrueԂ܂B<BR>
     * ̃[Uɓo^ς݂̏ꍇfalseԂ܂B
	 */
	public synchronized boolean add(String roleName, User user)
	throws IOException{
		String userName = user.getName();
		String pwd = user.getPwd();
		
		//[UŃpX[h(pwd)Í
		byte[] pwdAngou = AngouUtil.encrypt(userName, pwd);
		//[UƈÍpX[ho^
		HexPropertyFile roleFile = (HexPropertyFile)roleFiles.get(roleName);
		if(roleFile == null ){
			throw new RuntimeException("file not found for roleName[" + roleName + "]");
		}
		//pFile.removeAll();
		if( !roleFile.writeHex(userName, pwdAngou, true) ){
			//fail("̃[U͊ɓo^Ă܂ [" + user + "] pwd [" + pwd + "]" );
			return false;
		}
		reload();
		return true;
		
	}

    /**
     * w肳ꂽ[Uǉ܂
     * @param roleName [
     * @param name [U
     * @param pwd pX[h
     * @return ǉɐꍇtrueԂ܂B
     * ɓo^ς݂̏ꍇfalseԂ܂
     * @throws IOException
     */
    public boolean add(String roleName, String name, String pwd) throws IOException{
    	User user = new User();
    	user.setName(name);
    	user.setPwd(pwd);
    	return add(roleName, user);
    }
    
	/**
	 * [UXV܂
     * @param roleName 
     * @param user VK[U
     * @return boolean [U̓o^ɐꍇtrueԂ܂B<BR>
     * ̃[Uɓo^ς݂̏ꍇfalseԂ܂B
	 */
	public synchronized void update(String roleName, User user) throws IOException {
		delete(roleName, user);
		add(roleName, user);
	}
	
	/**
	 * [UF؂s܂
	 * @param roles t@C̃Xg
	 * @param user [U
	 * @return ̃[UÓłtrueԂ܂
	 */
    private boolean isRoles(HashMap roles, User user ) {
        Set keySet = roles.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            String key = (String)it.next();
            String roleName = (String)roles.get(key);
            HexPropertyFile roleFile = (HexPropertyFile)roleFiles.get(roleName);
            boolean ret = isRole(roleFile, user);
            if( ret ){
            	//Zbg
            	UserRole userRole = new UserRole();
            	userRole.setName(roleName);
            	user.setRole(userRole);
                return true;
            }
        }
        return false;
    }
    
    /**
	 * [UF؂s܂<BR>
	 * RoleFileManagerɓo^ĂSĂ̌񂩂Y
	 * [U݂邩ׂ܂B
	 * @param user [U
	 * @return ̃[UÓłtrueԂ܂
	 */
    private boolean isRoles(User user ){
    	Set keySet = roleFiles.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            String roleName = (String)it.next();
            HexPropertyFile roleFile = (HexPropertyFile)roleFiles.get(roleName);
            boolean ret = isRole(roleFile, user);
            if( ret ){
            	//Zbg
            	UserRole userRole = new UserRole();
            	userRole.setName(roleName);
            	user.setRole(userRole);
                return true;
            }
        }
        return false;
    }
    
    /**
     * w肳ꂽ[UANZXĂ邩肵܂<BR>
     * ÍꂽpX[hAngouNXɂĕ܂
     * @param User [U
     * @param roleFile [hꂽt@C
     * @return ̃[UɂANZXĂꍇtrueԂ܂
    */
    private boolean isRole(HexPropertyFile roleFile, User user){
        boolean ret = false;
        byte[] chkPwd = null;
        String userName = user.getName();
        String pwd = user.getPwd();
        
        try{
            chkPwd = roleFile.readHex(userName);
        }catch( Exception e ){
            throw new RuntimeException(e.getMessage());
        }
        
        if( chkPwd == null ){
            return ret;
        }
        
        //
        String chkPwdStr = new String();
        
        try{
            chkPwdStr = AngouUtil.decrypt(userName, chkPwd );
        }catch( Exception e ){
            throw new RuntimeException(e.getMessage());
        }
        if( chkPwdStr == null || chkPwdStr.length() == 0 ){
            return ret;
        }
        if( chkPwdStr.equals(pwd) ){
            ret = true;
        }
        return ret;
    }

	public HashMap getRoleDefines() {
		return roleDefines;
	}

	public void setRoleDefines(HashMap roleMaps) {
		this.roleDefines = roleMaps;
	}

	public String getRootPath() {
		return rootPath;
	}

	public void setRootPath(String rootPath) {
		this.rootPath = rootPath;
	}

}
