package org.itscool.weber.user;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.file.Log;
import org.itscool.commons.util.AngouUtil;
import org.itscool.commons.util.StringUtil;

/**
 * f[^x[XŊǗNXł<BR>
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/09/08
*/
public class RoleDbManager implements RoleManager{
	private Log log = Log.getInstance();
	
    /** BRoleManagerCX^X */
    private static RoleDbManager instance = null;
    
    /**
     * RoleManagerCX^X擾܂
     * @return RoleMangerCX^Xԋp܂
    */
    public static RoleDbManager getInstance(){
        if( instance == null ){
            instance = new RoleDbManager();
        }
        return instance;
    }
    
    /** vCx[gȃRXgN^ */
    private RoleDbManager(){
    	
    }
    
    public void init(){
    	
    }
    
    /**
     * w肳ꂽ[UANZXĂ邩肵܂<BR>
     * ÍꂽpX[hAngouNXɂĕ܂
     * @param roles 
     * @param user [U
     * @return ̃[UɂANZXĂꍇtrueԂ܂
    */
    public boolean isUserCheck(HashMap roles, User user ) {
    	if( user == null ){
    		return false;
    	}
        if( roles == null || roles.size() == 0 ){
        	return isRoles(user);
        }else{
        	return isRoles(roles, user);
        }
    }
    
    /**
	 * [UF؂s܂
	 * @param roles t@C̃Xg
	 * @param user [U
	 * @return ̃[UÓłtrueԂ܂
	 */
    private boolean isRoles(HashMap roles, User user ) {
        boolean ret = false;
        Set keySet = roles.keySet();
        Iterator it = keySet.iterator();
        
        UserDao dao = new UserDao();
        while( it.hasNext() ){
            String key = (String)it.next();
            String roleName = (String)roles.get(key);
            String userName = user.getName();
            User dbUser = dao.getUser(roleName, userName);
            ret = isRole(user, dbUser);
            if( ret ){
            	//Zbg
            	user.setRole(dbUser.getRole());
                return ret;
            }
        }
        return ret;
    }
    
    /**
	 * [UF؂s܂<BR>
	 * RoleFileManagerɓo^ĂSĂ̌񂩂Y
	 * [U݂邩ׂ܂B
	 * @param user [U
	 * @return ̃[UÓłtrueԂ܂
	 */
    private boolean isRoles(User user ){
    	boolean ret = false;
    	UserDao dao = new UserDao();
        List users = dao.getUsers(user.getName());
        
        for(int i=0; i<users.size(); i++){
            User dbUser = (User)users.get(i);
            ret = isRole(user, dbUser);
            if( ret ){
            	//Zbg
            	UserRole userRole = dbUser.getRole();
            	user.setRole(userRole);
                return ret;
            }
        }
        return ret;
    }
    
    /**
     * w肳ꂽ[UANZXĂ邩肵܂<BR>
     * ÍꂽpX[hAngouNXɂĕ܂
     * @param User [U
     * @param roleFile [hꂽt@C
     * @return ̃[UɂANZXĂꍇtrueԂ܂
    */
    private boolean isRole(User loginUser, User dbUser){
        
    	if( dbUser == null ) return false;
        if( loginUser == null ) return false;
        if( !dbUser.getName().equals(loginUser.getName())) return false;
        
        //pX[h̕
		String pwd = "";
		try{
			byte[] pwdBytes = StringUtil.decodeHex(dbUser.getPwd(), "ISO-8859-1");
			pwd = AngouUtil.decrypt(dbUser.getName(), pwdBytes );
		}catch(IOException ioe){
			throw new RuntimeException(ioe.getMessage());
		}
        if( !pwd.equals(loginUser.getPwd())) return false;
        
        //[UID̈p
        loginUser.setId(dbUser.getId());
        
        return true;
        
    }
    /**
     * pX[ht@C̍ēǂݍ݂s܂B
    */
    public void reload() {
        //non process
    }
    
    public List getAllData(){
		UserDao userDao = new UserDao();
		List users = userDao.getAllData();
		for(int i=0; i<users.size(); i++){
			User user = (User)users.get(i);
    		//pX[h̕
    		if( user != null ){
	    		String pwd = "";
	    		try{
	    			byte[] pwdBytes = StringUtil.decodeHex(user.getPwd(), "ISO-8859-1");
	    			pwd = AngouUtil.decrypt(user.getName(), pwdBytes );
	    		}catch(IOException ioe){
	    			throw new RuntimeException(ioe.getMessage());
	    		}
	    		user.setPwd(pwd);
    		}
		}
		return users;
    }
    
    /**
     * w肳ꂽ[UɊÂ[U擾܂
     * @param roleName [
     * @param userName [U
     * @return [UԂ܂
     */
    public User getUser(String roleName, String userName){ 
    	UserRoleDao dao = new UserRoleDao();
    	UserRole role = dao.getRole(roleName);
    	if( role != null ){
    		UserDao userDao = new UserDao();
    		User user = userDao.getUser(role, userName);
    		//pX[h̕
    		if( user != null ){
	    		String pwd = "";
	    		try{
	    			byte[] pwdBytes = StringUtil.decodeHex(user.getPwd(), "ISO-8859-1");
	    			pwd = AngouUtil.decrypt(user.getName(), pwdBytes );
	    		}catch(IOException ioe){
	    			throw new RuntimeException(ioe.getMessage());
	    		}
	    		user.setPwd(pwd);
    		}
    		return user;
    	}
    	return null; 
    }
    
    /**
     * w肳ꂽ[ŨXg擾܂
     * @param roleName [
     * @return [ŨXg
     */
    public HashMap getUsers(String roleName){ 
    	HashMap users = new HashMap();
    	UserRoleDao roleDao = new UserRoleDao();
    	UserRole role = roleDao.getRole(roleName);
    	UserDao dao = new UserDao();
    	List lst = dao.getUsers(role); 
    	for(int i=0; i<lst.size(); i++){
    		User user = (User)lst.get(i);
    		//pX[h̕
    		String pwd = "";
    		try{
    			byte[] pwdBytes = StringUtil.decodeHex(user.getPwd(), "ISO-8859-1");
    			pwd = AngouUtil.decrypt(user.getName(), pwdBytes );
    		}catch(IOException ioe){
    			throw new RuntimeException(ioe.getMessage());
    		}
    		user.setPwd(pwd);
    		users.put(user.getName(), user);
    	}
    	return users;
    }
    
    /**
     * w肳ꂽ[U폜܂
     * @param roleName [
     * @param user [U
     * @throws IOException
     */
    public void delete(String roleName, User user) throws IOException{
    	UserDao dao = new UserDao();
    	if(user.getRoleId() == -1){
    		UserRoleDao roleDao = new UserRoleDao();
    		UserRole role = roleDao.getRole(roleName);
    		user.setRoleId(role.getId());
    	}
    	dao.delete(user);
    }

    /**
     * w肳ꂽ[U폜܂
     * @param roleName [
     * @param name [U
     * @throws IOException
     */
    public void delete(String roleName, String name) throws IOException{
    	User user = new User();
    	user.setName(name);
    	delete(roleName, user);
    }
    
    /**
     * w肳ꂽ[Uǉ܂<BR>
     * [U̒ǉɐꍇUser.idIDlZbg܂B
     * @param roleName [
     * @param user [U
     * @return ǉɐꍇtrueԂ܂B
     * ɓo^ς݂̏ꍇfalseԂ܂
     * @throws IOException
     */
    public boolean add(String roleName, User user) throws IOException{
    	if(user.getRoleId() == -1){
    		UserRoleDao dao = new UserRoleDao();
    		UserRole role = dao.getRole(roleName);
    		if( role == null ){
    			return false;
    		}
    		user.setRoleId(role.getId());
    	}
    	UserDao dao = new UserDao();
    	if( getUser(roleName, user.getName()) == null ){
    		User newUser = (User)BeanUtil.copyInstance(user, User.class.getName());
    		
    		//pX[hÍ
    		byte[] pwdAngou = AngouUtil.encrypt(user.getName(), user.getPwd());
    		String pwdAngouStr = StringUtil.encodeHex(pwdAngou, "ISO-8859-1");
    		newUser.setPwd(pwdAngouStr);
    		
    		int id = dao.save(newUser);
    		//IDZbg
    		user.setId(id);
    		return true;
    	}else{
    		return false;
    	}
    }

    /**
     * w肳ꂽ[Uǉ܂
     * @param roleName [
     * @param name [U
     * @param pwd pX[h
     * @return ǉɐꍇtrueԂ܂B
     * ɓo^ς݂̏ꍇfalseԂ܂
     * @throws IOException
     */
    public boolean add(String roleName, String name, String pwd) throws IOException{
    	User user = new User();
    	user.setName(name);
    	user.setPwd(pwd);
    	return add(roleName, user);
    }
    
    /**
     * w肳ꂽ[UXV܂
     * @param roleName [
     * @param user [U
     * @throws IOException
     */
    public void update(String roleName, User user) throws IOException{
    	UserRoleDao roleDao = new UserRoleDao();
    	UserRole role = roleDao.getRole(roleName);
    	user.setId(role.getId());
    	
    	UserDao dao = new UserDao();
    	User newUser = (User)BeanUtil.copyInstance(user, User.class.getName());
		byte[] pwdAngou = AngouUtil.encrypt(user.getName(), user.getPwd());
		String pwdAngouStr = StringUtil.encodeHex(pwdAngou, "ISO-8859-1");
		newUser.setPwd(pwdAngouStr);
		
    	dao.update(newUser);
    	
    }
    
    public boolean addRole(UserRole role){
    	UserRoleDao roleDao = new UserRoleDao();
    	
    	if( roleDao.getRole(role.getName()) != null ){
    		return false;
    	}
    	
    	roleDao.save(role);
    	
    	return true;
    }
    
    public boolean deleteRole(UserRole role){
    	UserRoleDao roleDao = new UserRoleDao();
    	UserDao userDao = new UserDao();
    	
    	if( userDao.getUsers(role).size() > 0 ){
    		return false;
    	}
    	
    	roleDao.delete(role);
    	
    	return true;
    }
    
   
}
