package org.itscool.weber.tag;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.TagUtil;

/**
 * NCAg֕o͂^OłB<BR>
 * o͂enameŎw肵JavaBeanŝpropertyŎw肳ꂽ
 * vpeB擾ANCAgɏo͂܂B<BR>
 * propertyNULL̏ꍇnameŎw肵lo͂܂<BR>
 * NCAgւjava.lang.String^Ƃďo͂܂B<BR>
 * vpeBv~eBu^̏ꍇ͑Ή郉bp[NXtoString()\bh
 * ̌ʂɂȂ܂B<BR>
 *<BR>
 *yz<BR>
 * name ̃tB[h̏lݒ肷ۂɎgBean̖O(K{)<BR>
 * property nameŎw肵IuWFNg̃vpeBw肵܂B(ȗ\)<BR>
 *          propertyw肳ĂȂꍇnameŎ擾CX^XtoString()Ԃ܂<BR>
 * subproperty propertyɂĎ擾IuWFNg̃ow肷ƂɎgp܂B<BR>
 * scope propertỹXR[vw肵܂irequest, session, application)<BR>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
*/
public class WriteTag extends TagSupport {
	/** name */
    protected String name;
    /** property */
    protected String property;
    /** subproperty */
    protected String subproperty;
    /** value */
    protected String value;
    /** scope */
    protected String scope;
    
    /**
     * p[^ɃZbgꂽIuWFNgHTMLɏo܂B<br>
     * scopew肳ĂȂꍇ́ȀŃIuWFNg܂B
     * request, session, context̏
    */
    public int doStartTag() throws JspException {
        try {
        	Object result;
            if( value != null && value.length() > 0 ){
            	result = TagUtil.findValue(pageContext, value, scope);
            }else{
            	result = TagUtil.findProperty(pageContext, name, property, scope);
            	if( ( result != null && result.toString().length() > 0 )
	                && ( subproperty != null && subproperty.length() > 0) ){
	                //subpropertyipropertyɊYIuWFNg̃vpeB
	                //擾ꍇj
	                result = BeanUtil.getProperty(result, subproperty);
	            }
            }
            doOut(result);
        } catch (Exception e) {
            String err =
                "["
                    + property
                    + "]"
                    + "doStartTag() failed ("
                    + getClass().getName()
                    + ") ("
                    + e.getMessage()
                    + ")";
            throw new JspException(err);
        }

        return SKIP_BODY;
    }
    
    /**
     * IuWFNg̓eHTMLɏo͂܂
     * @param result o͓e
     * @throws IOException
     */
    public void doOut(Object result) throws IOException{
    	if (result == null || result.toString().length() == 0 ) {
            pageContext.getOut().print("");
        } else {
            pageContext.getOut().print(result);
        }
    }
    
    public int doEndTag() {
        return EVAL_PAGE;
    }

    /**
     * O擾܂
     * @return name O
     */
    public String getName() {
        return name;
    }
    /**
     * OZbg܂
     * @param name O
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * vpeB擾܂
     * @return property vpeB
     */
    public String getProperty() {
        return property;
    }
    /**
     * vpeBZbg܂
     * @param property vpeB
     */
    public void setProperty(String property) {
        this.property = property;
    }
    /**
     * XR[v擾܂
     * @return scope XR[v
     */
    public String getScope() {
        return scope;
    }
    /**
     * XR[vZbg܂
     * @param scope XR[v
     */
    public void setScope(String scope) {
        this.scope = scope;
    }
    /**
     * TuvpeB擾܂
     * @return TuvpeB
     */
    public String getSubproperty() {
        return subproperty;
    }

    /**
     * TuvpeBZbg܂
     * @param string TuvpeB
     */
    public void setSubproperty(String string) {
        subproperty = string;
    }

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
    
}
