package org.itscool.weber.tag;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.itscool.commons.util.TagUtil;
import org.itscool.weber.action.Globals;

/**
 * NCAg֕o͂^OłB<BR>
 * o͂enameŎw肵JavaBeanŝpropertyŎw肳ꂽ
 * vpeB擾ANCAgɏo͂܂B<BR>
 * NCAgւjava.lang.String^Ƃďo͂܂B<BR>
 * vpeBv~eBu^̏ꍇ͑Ή郉bp[NXtoString()\bh
 * ̌ʂɂȂ܂B<BR>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 * 
*/
public class ErrorTag extends TagSupport {

	/**
	 * tH[̓G[JSPy[W𐶐܂<BR>
	 * scopew肳ĂȂꍇ́ȀŃG[IuWFNg
	 * ܂<BR>B
	 * request, session, context̏
	 * @return SKIP_BODYԂ܂
	*/
	public int doStartTag() throws JspException {

		try {
			
			HashMap errMap =
				(HashMap)TagUtil.findObject(
					pageContext,
					Globals.REQ_PARAM_FORM_ERR,
					TagUtil.SCOPE_REQUEST);
			StackTraceElement[] errTrace =
				(StackTraceElement[])TagUtil.findObject(
				pageContext,
				Globals.REQ_PARAM_SYSTEM_ERR,
				TagUtil.SCOPE_REQUEST);
			String errMsg =
				(String)TagUtil.findObject(
				pageContext,
				Globals.REQ_PARAM_SYSTEM_ERR_MSG,
				TagUtil.SCOPE_REQUEST);
				
			if( errMap == null && errTrace == null && errMsg == null ){
				return SKIP_BODY;
			}
			
			//VXeO`FbN
            if ( errTrace != null && errMsg != null &&
            errTrace.length > 0 && errMsg.length() > 0 ){
				createErrObject(errTrace, errMsg);
            //tH[̓G[`FbN
			}else if (errMap != null) {
                createErrObject(errMap);
            }
			
			//G[̍폜
			pageContext.getRequest().removeAttribute(
				Globals.REQ_PARAM_FORM_ERR);

		} catch (Exception e) {
			String err =
				"["
					+ "org.itscool.action.ERROR"
					+ "]"
					+ "doStartTag() failed ("
					+ ErrorTag.class.getName()
					+ ") ("
					+ e.getMessage()
					+ ")";
			throw new JspException(err);
		}

		return SKIP_BODY;
	}

	private void createErrObject(HashMap map) throws IOException {
		//tH[̓G[IuWFNg擾܂

		//G[o͂܂
		Collection values = map.values();
		Iterator it = values.iterator();
		
		JspWriter out = pageContext.getOut();
		out.println("<div align=\"center\">");
		while (it.hasNext()) {
			out.println((String) it.next() + "<BR>");
		}
		out.println("</div>");
		out.println("<HR>");
	}
	
	private void createErrObject(StackTraceElement[] errObject,
	String errMsg) throws IOException {
		//tH[̓G[IuWFNg擾܂

		//G[o͂܂
		JspWriter out = pageContext.getOut();
		out.println("<div align=\"left\">");
		out.println(errMsg);
		out.println("<HR>");
		for( int i=0; i<errObject.length; i++ ){
			out.print("    at ");
			out.println((String) errObject[i].toString() + "<BR>");
		}
		out.println("</div>");
	}
	
	
	public int doEndTag() {
		return EVAL_PAGE;
	}

}
