package org.itscool.weber.tag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.TagUtil;

/**
 * vꂽϐw肳ꂽlƓꍇÃ^O̓e]܂
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/10/26
*/
public class EqualTag extends BodyTagSupport {
	/** name */
    protected String name;
    /** property */
    protected String property;
    /** subproperty */
    protected String subproperty;
    /** value */
    protected String value;
    /** scope */
    protected String scope;
    
    public int doStartTag() throws JspException {
        try {
            Object result = TagUtil.findProperty(pageContext, name, property, scope);
            if( ( result != null && result.toString().length() > 0 )
              && ( subproperty != null && subproperty.length() > 0) ){
                //subpropertyipropertyɊYIuWFNg̃vpeB
                //擾ꍇj
                result = BeanUtil.getProperty(result, subproperty);
            }
            
            if(result == null && value == null){
            	return SKIP_BODY;
            }
            
            try{
            	//ELΉo[W
            	value = TagUtil.findValue(pageContext, value, scope).toString();
            	
            	double num1 = Double.parseDouble(result.toString());
            	double num2 = Double.parseDouble(value.toString());
            	
            	return doParamCheck(num1, num2);
            	
            }catch(NumberFormatException nfe){
            	return SKIP_BODY;
            }
        } catch (Exception e) {
            String err =
                "["
                    + property
                    + "]"
                    + "doStartTag() failed ("
                    + EqualTag.class.getName()
                    + ") ("
                    + e.getMessage()
                    + ")";
            throw new JspException(err);
        }
    }
    
    public int doParamCheck(double num1, double num2){
    	if( num1 == num2 ){
    		return EVAL_BODY_INCLUDE;
    	}else{
    		return SKIP_BODY;
    	}
    }
    
    
    public int doEndTag() {
        return EVAL_PAGE;
    }

    /**
     * O擾܂
     * @return name O
     */
    public String getName() {
        return name;
    }
    /**
     * OZbg܂
     * @param name O
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * vpeB擾܂
     * @return property vpeB
     */
    public String getProperty() {
        return property;
    }
    /**
     * vpeBZbg܂
     * @param property vpeB
     */
    public void setProperty(String property) {
        this.property = property;
    }
    /**
     * XR[v擾܂
     * @return scope XR[v
     */
    public String getScope() {
        return scope;
    }
    /**
     * XR[vZbg܂
     * @param scope XR[v
     */
    public void setScope(String scope) {
        this.scope = scope;
    }
    /**
     * TuvpeB擾܂
     * @return TuvpeB
     */
    public String getSubproperty() {
        return subproperty;
    }

    /**
     * TuvpeBZbg܂
     * @param string TuvpeB
     */
    public void setSubproperty(String string) {
        subproperty = string;
    }

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
    
}
