package org.itscool.weber.mapping;

import java.util.HashMap;

import org.itscool.commons.dao.DaoInfo;
import org.itscool.commons.dao.RecordMap;

public class DaoInfoMapping extends HashMap{
	/** BMessageMappingsCX^X */
    private static DaoInfoMapping instance;
    
    /**
     * BMessageMappingsCX^X擾܂
     * @return MessageMappingsCX^X
    */
    public static synchronized DaoInfoMapping getInstance(){
        if( instance == null ){
            instance = new DaoInfoMapping();
        }
        return instance;
    }
    

	public DaoInfo getDaoInfo(String clazzName){
		DaoInfo daoInfo = (DaoInfo)this.get(clazzName);
		return daoInfo;
	}
	
	public RecordMap getGRecordMap(String clazzName){
		DaoInfo daoInfo = getDaoInfo(clazzName);
		return daoInfo.getGRecordMap();
	}
	
	public HashMap getFkRecordMaps(String clazzName){
		DaoInfo daoInfo = getDaoInfo(clazzName);
		return daoInfo.getFkRecordMaps();
	}
	
	public RecordMap getGRecordMap(Class clazz){
		DaoInfo daoInfo = getDaoInfo(clazz.getName());
		if(daoInfo == null) return null;
		return daoInfo.getGRecordMap();
	}
	
	public HashMap getFkRecordMaps(Class clazz){
		DaoInfo daoInfo = getDaoInfo(clazz.getName());
		if(daoInfo == null) return null;
		return daoInfo.getFkRecordMaps();
	}
}
