package org.itscool.weber.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.file.Log;

/**
 * gUNVptB^<BR>
 * RlNVv[̏yуf[^ANZXwŎsꂽgUNV
 * ̎sʂR~bg/[obNstB^łB
 * 
 * @author kanou
 *
 */
public class TransactionFilter implements Filter{
	private Log log = Log.getInstance();
	
	/**
	 * RlNVv[̏s܂<BR>
	 * BeanFactoryCX^XgāAweb.xml̃ReLXgp[^udi-config-frameworkv
	 * Ɏw肳ꂽBean`t@CConnectionMangaerCX^X擾܂B
	 * BeanFactoryCX^XStartupFilterł炩ߏĂKv܂B
	 * 
	 * @param filterConfig FilterConfigCX^X
	 */
	public void init(FilterConfig filterConfig) throws ServletException {
//		System.out.println("-- Starting " + this.getClass().getName() + " --");
//		ServletContext context = filterConfig.getServletContext();
//		String configName = context.getInitParameter("di-config");
//		String rootPath = context.getRealPath("/");
//		String configPath = rootPath + configName;
//		System.out.println("-- Create ConnectionPool Instance --");
        
        BeanFactory factory = BeanFactory.getInstance();
		if( !factory.isInit() ){
			try{
        		factory.createForUrl("di-config.xml");
        	}catch(Exception ex){
        		ex.printStackTrace();
            	throw new ServletException(ex.getMessage());
        	}    
		}
		
//modify 2006/03/12 kano start
        try{
        	log = (Log)factory.createInstance("Log");
        }catch(Exception ioe){
        	log.warn(ioe.getMessage());
        }
//modify 2006/03/12 kano end
        
        try{
        	//log = (Log)factory.createInstance("Log");
        	ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
            manager.init();
            log.info("completed initialize instance='" + manager.getClass().getName() + "'" );
            log.info("ConnectionManager Info="+manager.toString());
        }catch(Exception ex){
        	log.error(ex.getMessage());
            throw new ServletException(ex.getMessage());
        }
    }
	
	/**
	 * chain.doFilter()sɃgUNṼR~bg/[obNs܂<BR>
	 * gUNV͈ȉ̗ōs܂<BR>
	 * (1) chain.doFilter()̌Ăяo<BR>
	 * (2) TransactionUtil.getTransaction()ThreadLocalɃZbgĂTransaction
	 * CX^X擾<BR>
	 * (3) TransactionCX^X̃Xe[^X擾<BR>
	 * (4) Xe[^XPLEASE_COMMIT̏ꍇ̓R~bgs܂<BR>
	 * (4)' Xe[^XPLEASE_ROLLBACK̏ꍇ̓[obNs܂<BR>
	 * (4)'' Exceptionꍇ[obNs܂<BR>
	 * (4)''' ȊȌꍇ͉s܂<BR>
	 * (5) ThreadLocalɃZbgꂽgUNVRlNVv[ɖ߂܂<BR>
	 * 
	 * @param request ServletRequestCX^X
	 * @param response ServletResponseCX^X
	 */
    public void doFilter(ServletRequest request, ServletResponse response,
    FilterChain chain)
    throws IOException, ServletException {

        try {
        	//gUNVJn܂B
        	TransactionUtil.beginTransaction();
        	//ƖWbNs܂B
            chain.doFilter(request, response);
            //gUNVXe[^XPLEASE_COMMITȂR~bgs
            if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_COMMIT ){
            	TransactionUtil.commitTransaction();
            	log.debug("COMMIT TRANSACTION");
            }else if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_ROLLBACK){
            	TransactionUtil.rollbackTransaction();
            	log.debug("ROLLBACK TRANSACTION");
            }
        }catch(IOException ioe){
          	TransactionUtil.rollbackTransaction();
          	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
            throw ioe;
            
        }catch(ServletException se){
          	TransactionUtil.rollbackTransaction();
          	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
            throw se;
        //2005/09/27 add start
        } catch (NullPointerException e) {
        	TransactionUtil.rollbackTransaction();
        	TransactionUtil.returnTransaction();
        	log.debug("ROLLBACK TRANSACTION");
			throw new ServletException(e.getMessage());
		}catch(RuntimeException re){
        	TransactionUtil.rollbackTransaction();
        	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
            throw new ServletException(re.getMessage());
        }catch(Exception e){
        	TransactionUtil.rollbackTransaction();
        	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
            throw new ServletException(e.getMessage());
        //2005/09/27 add end
        } finally {
        	//gUNVI܂B
        	TransactionUtil.returnTransaction();
        }
    }
    
    /**
     * SẴRlNVARlNVv[J܂ 
     */
    public void destroy() {
    	BeanFactory factory = BeanFactory.getInstance();
        ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
        manager.destroy();
    }
}
