package org.itscool.weber.action;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.request.GeneralForm;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.user.RoleManager;
import org.itscool.weber.user.User;

/**
 * webert[[NŋƖWbN邽߂̊{NXł<P>
 * 
 * J҂ActionNXpTuNX`ArWlX\bhĂяo
 * ߂doExecute\bhI[o[ChĎKv܂B<BR>
 * doExecute\bh̓t[[NK؂ȃ^C~OŌĂяo܂B<P>
 * 
 *yActionNX̃CX^XǗz<BR>
 * ActionNX̃IuWFNg̓NGXgɉFrontServletCX^X
 * ܂B<BR>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public abstract class Action{
    /** tH[hCX^X */
    private HashMap lnkForwards;
    /** ActionBucketCX^X */
    private ActionBucket bucket;
    
    /** 
     * NGXgp[^ێ[HTTPServleteRequestNX 
    */
    private GeneralForm generalForm = null;
    /** 
     * G[Xg<BR>
     * ͌؂ɂĔG[ڂێ郊Xg 
    */
    private HashMap errList = new HashMap();
    
    /**
     * _tH[hJSP̑JڐƂȂpX擾܂
     * @param name _tH[h
     * @return _tH[hJSP̑JڐƂȂpX
     */
    public String getForward( String name ){
        return (String)lnkForwards.get(name);
    }
    
    /**
     * tH[h̃XgZbg܂
     * @param forwards tH[h̃Xg
     */
    public void setForwards( HashMap forwards ){
        this.lnkForwards = forwards;
    }

    /**
     * @param generalForm GeneralForm ݒB
     */
    public void setGeneralForm(GeneralForm generalForm) {
        this.generalForm = generalForm;
    }
    
	/**
     * FrontServletCX^XĂ΂ŏ̃ANVł
     * @param lnkServlet FrontServletCX^X
     * @param request HttpServletRequestCX^X
     * @param response HttpServletRespneceCX^X
     * @param roles ̃ANV錠Xg
     * @return tH[h̘_Ԃ܂
     * @throws Exception
     */
    public void init(FrontServlet lnkServlet,
        HttpServletRequest request,
        HttpServletResponse response,
        Object bean, HashMap roles,
        GeneralForm generalForm){
        
        //=========================
        //execute()bvNX𐶐
        //=========================
        ActionBucket bucket = new ActionBucket();
        bucket.setServlet(lnkServlet);
        bucket.setRequest(request);
        bucket.setResponse(response);
        bucket.setForm(bean);
        bucket.setRoles(roles);
        
        this.bucket = bucket;
        this.setGeneralForm(generalForm);
    }
    
	/**
     * FrontServletCX^XĂ΂ŏ̃ANVł
     * @param lnkServlet FrontServletCX^X
     * @param request HttpServletRequestCX^X
     * @param response HttpServletRespneceCX^X
     * @param roles ̃ANV錠Xg
     * @return tH[h̘_Ԃ܂
     * @throws Exception
     */
    public String execute() throws Exception{
        
        //=========================
        //ANZX`FbN܂
        //=========================
        if(!checkUserRole(bucket)){
            return doAuthFailure(bucket);
        }
        
        //========
        //͌
        //========
        String ret = validate(bucket);
        if(!ret.equals(Globals.RET_SUCCESS)){
        	//NGXgp[^ZbgȂ
            bucket.setRetryInputParam(generalForm);
        	return ret;
        }
        
        //=========================
        //rWlXWbNs
        //=========================
        return doExecute(bucket);
    }
    
    /**
     * webert[[NƎ̃ANZX[Ǔ`FbN܂B<br>
     * F؃G[̏ꍇ́AdoAuthFailure\bhĂ΂܂<br>
     * Ǝ̔F؏sꍇ́ATuNXł̃\bhI[o[Ch
     * ėp鎖ł܂B
     * @param bucket
     * @return ̃ANVĂꍇtrueԂ܂
     */
    public boolean checkUserRole(ActionBucket bucket){
        boolean  ret = true;
        if(bucket.getRoles() == null || bucket.getRoles().size() == 0){
            return true;
        }else{
            //OC`FbN
            User user = (User)bucket.getAttributeFromSession(Globals.REQ_PARAM_USER);
            if(user == null){
                ret = false;
            }else{
                ret = isUserCheck(bucket.getRoles(), user);
            }
            
        }
        return ret;
    }
    
    /**
     * ͌؂Jn܂<BR>
     * ̃\bhFrontServletĂ΂܂B<BR>
     * FontServlet炱̃\bhĂ΂ƁAG[؏̂߂
     * OsǍdoValidate\bhĂяo܂<BR>
     * doValidate\bhł́ATuNXœ͌؂s߂̃WbN
     * 邽߂Ɏgp܂B
     * @param generalForm NGXgp[^ێNX
     * @return ͌؂ɍsꂽꍇGlobals.RET_SUCCESSԂ܂<BR>
     * ͌؃G[̏ꍇdoInputFailure()ԂlĂяoɕԂ܂B
     * <BR>͌؂Ɏsꍇ́AG[bZ[W̃XgHashMapŕԂ܂
     */
    public String validate(ActionBucket bucket) throws Exception{
    	doValidate(bucket);
        if(isInputError()){
        	bucket.setAttribute(Globals.REQ_PARAM_FORM_ERR, errList);
            return doInputFailure(bucket);
        }else{
        	return Globals.RET_SUCCESS;
        }
    }
    
    /**
     * ActionNXececute()\bhbv郁\bhłB<br>
     * TuNXŒ`ĂB<br>
     * doExecute\bhɂ͈ƂBeanCX^XAHttpServletRequest,
     * HttpServletResponsebvActionBucketCX^Xn܂<br>
     * ̂ŊJ҂̓rWlXWbN̂߂ɃNCAg瑗MꂽNGXg
     * f[^⃊NGXgXR[vAZbVXR[vɊi[Ă
     * Rɏ鎖łA܂rWlXWbN̏ʂNGXgXR[v
     * ZbVXR[vɊi[鏈Lqł܂B<br>
     * @param bucket
     * @return Action̎sʂtH[hŕԂ܂
     */
    public abstract String doExecute(ActionBucket bucket) throws Exception;
    
    /**
    * tH[̓͌؂s܂B<br>
    * KvɉActionNX̃TuNXŒ`Ă
    */
    protected void doValidate() throws Exception{}

    /**
     * ͌؂s\bhł<BR>
     * ̃\bhTuNXŒ`AeANVƂ̓͌
     * WbNĂB
     */
    protected void doValidate(ActionBucket bucket) throws Exception{
    	this.doValidate();
    }
    
    /**
     * ̂Ȃ[UANVvƂɌĂ΂܂B<BR>
     * Ǝ̔F؏ꍇ́Ã\bhI[o[Ch
     * ėp鎖ł܂B<br>
     * @param bucket ActionBucketCX^X
     * @return@ftHgłGlobals.ROLE_FAILԂ܂
     */
    protected String doAuthFailure(ActionBucket bucket){
        return Globals.RET_ROLE_FAIL;
    }
    
    /**
     * tH[̓͌؂ŃG[ƂɌĂ΂܂B<BR>
     * Ǝ̌؃G[ꍇ́Ã\bhI[o[Ch
     * ėp鎖ł܂B<br>
     * @param bucket ActionBucketCX^X
     * @return@ftHgłGlobals.REQ_PARAM_FORM_ERRԂ܂
     */
    protected String doInputFailure(ActionBucket bucket){
    	return Globals.REQ_PARAM_FORM_ERR;
    }
    
    /**
     * ̃ANVĂ邩܂<br>
     * ̃\bhcheckUserRole\bhĂ΂܂B<br>
     * Ǝ̔F؏ꍇ́Ã\bhI[o[Ch
     * ėp鎖ł܂B
     * @param roles 
     * @param user [U
     * @return ̃ANVĂꍇtrue
     * Ԃ܂
     */
    public boolean isUserCheck(HashMap roles, User user){
        boolean ret = false;
        BeanFactory factory = BeanFactory.getInstance();
        RoleManager manager = (RoleManager)factory.createInstance("RoleManager");
        ret = manager.isUserCheck(roles, user);
        
        return ret;
        
    }
    /**
     * G[R[hǉ܂
     * @param key G[肷邽߂̃j[NL[
     * @param msg G[bZ[W
     */
    protected void putMessage( Object key, Object msg){
        errList.put(key, msg);
    }
    
    /**
     * G[R[hǉ܂<BR>
     * G[L[(key)Ŏw肳ꂽbZ[WMessageResourcesCX^X
     * 擾A擾G[bZ[WƃG[L[G[Xgɒǉ܂
     * @param key G[肷邽߂̃j[NL[
     */
    protected void putMessage( Object key ){
        MessageMappings messages = MessageMappings.getInstance();
        String message = (String)messages.get(key);
        putMessage(key, message);
    }
    
    /**
     * G[茋ʂԂ܂
     * @return tH[̓G[ꍇtrueԂ܂
     */
    public boolean isInputError(){
        boolean ret = false;
        
        if( errList.size() > 0 ){
            ret = true;
        }
        
        return ret;
    }
    
    
    /**
     * p[^int^ł邩؂܂
     * @param paramName p[^w肵܂
     * @return ؂ꍇtrueԂ܂
     */
    protected boolean isInt(String paramName){
        boolean ret = true;
        
        try{
            String paramValue = (String)getParameter(paramName);
            Integer.parseInt(paramValue);
        }catch(Exception e ){
            ret = false;
        }
        return ret;
    }
    
    /**
     * p[^long^ł邩؂܂
     * @param paramName p[^w肵܂
     * @return ؂ꍇtrueԂ܂
     */
    protected boolean isLong(String paramName){
        boolean ret = true;
    
        try{
            String paramValue = (String)getParameter(paramName);
            Long.parseLong(paramValue);
        }catch(Exception e ){
            ret = false;
        }
        return ret;
    }
        
    /**
     * p[^double^ł邩؂܂
     * @param paramName p[^w肵܂
     * @return ؂ꍇtrueԂ܂
     */
    protected boolean isDouble(String paramName){
        boolean ret = true;
        
        try{
            String paramValue = (String)getParameter(paramName);
            Double.parseDouble(paramValue);
        }catch(Exception e ){
            ret = false;
        }
        return ret;
    }
    
    /**
     * p[^float^ł邩؂܂
     * @param paramName p[^w肵܂
     * @return ؂ꍇtrueԂ܂
     */
    protected boolean isFloat(String paramName){
        boolean ret = true;
        
        try{
            String paramValue = (String)getParameter(paramName);
            Float.parseFloat(paramValue);
        }catch(Exception e ){
            ret = false;
        }
        return ret;
    }
    
    /**
     * p[^short^ł邩؂܂
     * @param paramName p[^w肵܂
     * @return ؂ꍇtrueԂ܂
     */
    protected boolean isShort(String paramName){
        boolean ret = true;
        
        try{
            String paramValue = (String)getParameter(paramName);
            Short.parseShort(paramValue);
        }catch(Exception e ){
            ret = false;
        }
        return ret;
    }
    
    /**
     * p[^nullłȂƂ؂܂
     * @param paramName p[^w肵܂
     * @return ؂ꍇtrueԂ܂
     */
    protected boolean isNotNull(String paramName){
        boolean ret = true;
        
        try{
            Object paramValue = getParameter(paramName);
            if( paramValue == null || paramValue.toString().length() == 0){
                ret = false;
            }
        }catch(Exception e ){
            ret = false;
        }
        
        return ret;
    }
    
    
    /**
     * p[^擾܂
     * @param paramName p[^
     * @return p[^String^ŕԂ܂
     */
    protected Object getParameter(String paramName){
        String result = null;
        Object obj = generalForm.getParameter(paramName);
        return obj;
    }
    
}

