package org.itscool.stylist.io;

import java.io.IOException;
import java.util.LinkedList;

import org.itscool.commons.file.ConfigReader;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutPutMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * &lt;include-mappings&gt;vf͂NXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class LayoutConfigReader extends ConfigReader{
    /**
     * XMLt@C&lt;include-mappings&gt;vf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param hashMap XML̉͌
    */
    protected void doCreate(LinkedList hashMap) throws IOException{
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at stylist-config.xml(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        /* include-mappings ̎擾*/
        NodeList includeList = root.getElementsByTagName("layout-mappings");
        if( includeList == null ){
            String err = "Can not element at <layout-mappings>(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        Node include = includeList.item(0);
        if( include != null ){
            createIncludes(include, hashMap);
        }
    }
    
    /**
     * &lt;include&gt;vf͂܂
     * @param includes &lt;include&gt;vf
     * @param hashMap ͌&lt;include&gt;ǉm[hXg
     * @throws Exception
     */
    protected void createIncludes(Node includes, LinkedList hashMap){
        NodeList includesChilds = includes.getChildNodes();
        
        for( int i = 0; i < includesChilds.getLength(); i++) {
            Node include = includesChilds.item(i);
            if( include.getNodeName().equals("layout")){
                createInclude(include, hashMap);
            }
        }
    }
    
    /**
     * &lt;include&gt;vf̑͂܂
     * @param include &lt;include&gt;vf
     * @param hashMap ͌&lt;include&gt;ǉm[hXg
     * @throws Exception
     */
    protected void createInclude(Node include, LinkedList hashMap){
        NamedNodeMap attributes = include.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node name = attributes.getNamedItem("name");
        Node extendz = attributes.getNamedItem("extends");
        /*
        System.out.print("[" + include.getNodeName() + "] ");
        System.out.print(name.getNodeName() + ":" + name.getNodeValue() + " , ");
        System.out.println(path.getNodeName() + ":" + path.getNodeValue());
        */
        LayoutMapping includeMapping = new LayoutMapping(name.getNodeValue());
        
        includeMapping.setPath(path.getNodeValue());
        if(extendz != null){
            includeMapping.setExtendz(extendz.getNodeValue());
        }
        NodeList includeChilds = include.getChildNodes();
        for( int i=0; i<includeChilds.getLength(); i++ ){
            Node put = includeChilds.item(i);
            if( put.getNodeName().equals("put")){
                createPut(put, includeMapping );
            }
        }
        hashMap.addFirst(includeMapping );
        
    }
    
    /**
     * CN[h쐬܂
     * @param put XMLǂݍ񂾃CN[h
     * @param includeMapping LayoutMappingCX^X
     */
    protected void createPut(Node put, LayoutMapping includeMapping){
        NamedNodeMap attributes = put.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node name = attributes.getNamedItem("name");
        
        LayoutPutMapping putMapping = new LayoutPutMapping(name.getNodeValue(), path.getNodeValue());
        /*
        System.out.print("[" + put.getNodeName() + "] ");
        System.out.print(name.getNodeName() + ":" + name.getNodeValue() + " , ");
        System.out.println(path.getNodeName() + ":" + path.getNodeValue());
        */
        includeMapping.addPut(name.getNodeValue(), putMapping );
    }
}
