package org.itscool.stylist.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.file.ConfigReader;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutMappings;
import org.itscool.stylist.mapping.LayoutPutMapping;

/**
 * WebRec̃CAEgsFilterNXł<br>
 * stylistt[[NComposit Viewp^[gJSP̃CAEg
 * S郌CAEgGW̃NXŎ܂B<br>
 * <hr>
 * Composite Viewp^[ɂ<br>
 * <hr>
 * [Ƃ߂Ă͂܂B<br>
 * 悤ȉƂW܂cn݂ꍇAꂼƗvWFNg
 * ƂĊe˂̍Ƃɒ肷邱Ƃ͂Ȃł傤B<br>
 * ̑ɁA^ƂȂ݌vɂāAhAAAԎȂǂ̋ʗvf
 * ėp邱Ƃł傤B<br>
 * ̃p^[̔wiɂ̂͂̂悤ȍlłB<p>
 * 
 * WebAvP[V́Aj[AirQ[Vo[AƃSȂǂ́A
 * JԂgvfō\镡Gȉʂ̂ʓIłB<p>
 * 
 * Composite Viewp^[ł́AʂfЂɕAefЂꂼꊮP
 * ƂăR[fBO邱ƂĂ܂B<br>
 * ̃p^[́AWebAvP[V̉ʂ̃bNAhtB[𓝈ꂷ邽
 * ɖ𗧂Ar[̍\vf̍ėp𑣐i܂B<p>
 *
 * JSPpComposite Viewp^[̂͊ȒPłB
 * ̎ɗpł2̑gݍ݃JjY <%@ include> fBNeBu
 * includeANV܂B<p>
 * 
 * stylistt[[Nł́ALayoutFilterʂĎsꂽT[ubg̎s
 * ʂ⃌CAEgJSPɖߍJSPpXHttpServletRequestCX^XɃZbg
 * AIncludeTagincludefBNeBugČĂяoĂ܂
 * <p>
 * CAEg̒`stylist-config.xmlgĈȉ̂悤ɒ`܂B
 * <p>
 * [CAEg̐ݒ]
 * <p>
 * <?xml version="1.0" encoding="Shift_JIS" ?>
 * <stylist-config>
 *   <layout 
 *        name="/*.do"
 *        path="/WEB-INF/jsp/layout.jsp">
 *        <!-- ̃CAEgɔzuJSPw肵܂                     -->
 *        <!-- T[ubg̎sʂname=bodyɃZbg܂B     -->
 *        <!-- name=bodystylistŗ\񂳂ĂL[[hł邽  -->
 *        <!-- layoutvfɂ̓ZbgȂł                       -->
 *        <!--yz                                                     -->
 *        <!-- name F CAEgɔzuJSP̘_w肵܂         -->
 *        <!-- path F CAEgɔzuJSP̃pXw肵܂           -->
 *        <!-- extendsF-->
 *        <put name="header" path="/WEB-INF/jsp/header.jsp"/>
 *        <put name="menu" path="/WEB-INF/jsp/menu.jsp"/>
 *    </layout>
 * </layout-mappings>
 * </stylist-config>
 *
 * @author KANO 쐬F 2004/12/12
 * @version 1.11A 2005/05/20 Include@\폜iweberƂ̕j
 * @version 1.20A 2005/05/20 JSPsʂHTMLAHEADABODY菜ǉ
 * @version 1.30A 2006/06/23 ÓIReciHTML)Ήǉ
 */
public class LayoutFilter implements Filter {
	private FilterConfig filterConfig = null;

	/**
	 * LayoutFilter܂<br>
	 * 
	 * stylist-config.xmlJSP̃CAEg[h܂<br>
	 * init()ŗOtomcat̋NɎŝŁAOLb`
     * ꍇ̓X[catchď𐳏ɏIĂB
	 * @param config FilterConfigCX^X
	 */
	public void init(FilterConfig config) throws ServletException {
		if (filterConfig == null) {
			filterConfig = config;
		}
		BeanFactory factory = BeanFactory.getInstance();
		if( !factory.isInit() ){
			try{
        		factory.createForUrl("di-config.xml");
        	}catch(Exception ex){
        		ex.printStackTrace();
            	throw new ServletException(ex.getMessage());
        	}    
		}
		LayoutMappings includeMappings = LayoutMappings.getInstance();
//		ClassLoader parent = ClassLoader.getSystemClassLoader();
//		ClassLoader parent = filterConfig.getClass().getClassLoader();
//	    ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
//	    URL stylistConfigUrl = parent.getResource("stylist-config.xml");
	    
		try {
//			if( stylistConfigUrl == null ){
//        		throw new ServletException("stylist-config.xmlւ̃pX܂");
//        	}
//			String configName = stylistConfigUrl.getPath();
//            ConfigReader includeReader = new LayoutConfigReader();
//			includeReader.create(configName, includeMappings);
			ConfigReader includeReader = (ConfigReader)factory.createInstance("LayoutConfigReader");
			includeReader.create(includeMappings);
			
		} catch (Exception ioe) {
			//throw new ServletException(ioe);
            ioe.printStackTrace();
		}
	}

	/**
	 * T[ubgNGXg̎sʂtbNāAJSP̃CAEgɖߍ݂܂<Br>
	 * @param request ServletRequestCX^X
	 * @param response ServletResponseCX^X
	 * @param chain FiltercahinCX^X
	 */
	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
		throws IOException, ServletException {

		HttpServletRequest req = (HttpServletRequest) request;
		HttpServletResponse res = (HttpServletResponse) response;
		String path = (req).getServletPath();

		String jsp = layout(path, (req));
		if (jsp == null) {
		    chain.doFilter(req, res);
		    return;
		}
		
		//ServletResponsẽbp[IuWFNg쐬܂
		LayoutPageResponseWrapper wrapper = new LayoutPageResponseWrapper(res);
		
		//XvĂ\[XT[ubgɓn܂B
		//ServletResponse̓bp[IuWFNgnÃbp[IuWFNg
		//T[ubg̎sʂZbg܂
		chain.doFilter(req, wrapper);

		//NGXgURI擾
		//String uri = (req).getRequestURI();
		//System.out.println("uri:" + uri);

//add 2006/03/24 kano start
		//ÓIRec(HTML)Ή
		//ÓIRecFrontServletŃtH[hꍇA
		//ÓIRec̃TCYHeaderɃZbgA
		//CAEgJSPs̃TCYXVȂۂւ̑Ή
		//T[ubgsɁAX|XUNAB
		res.reset();
//add 2006/03/24 kano end
		
		//T[ubgŃtH[h/CN[hsꂽꍇ
		//sΏۂƂȂRec擾
//      2005.05.20 -start-
//        String contentsName =
//			(String) (req).getAttribute(Globals.REQ_PARAM_INCLUDE_CONTENTS_NAME);
//      2005.05.20 -end-

		//T[ubg̎sʂbytezŃZbg܂
		//JSPɕ\ƂIncludeTagŎ擾܂
		byte[] buff = wrapper.getByteStream().toByteArray();
        String buffStr = new String(buff);
        
//      2005.05.20 -start-
        //JSPsʂHTMLAHEADABODY菜
        TagInfo body = TagUtil.createTagInfo(buffStr, TagInfo.BODY_NAME);
        TagInfo head = TagUtil.createTagInfo(buffStr, TagInfo.HEAD_NAME);
        
        if( body != null ){
            //BODY̏o
            ((HttpServletRequest) req).setAttribute(Globals.REQ_PARAM_INCLUDE_BODY,
                body.getDataInTag().getBytes());
            //BODYvfLq̏óiCAEgŐU蕪j
            ((HttpServletRequest) req).setAttribute(Globals.REQ_PARAM_INCLUDE_BODY_TAG,
                body.getStartTag().getBytes());
            if(head != null ){
                //HEADvfLq̏óiCAEgŐU蕪j
                ((HttpServletRequest) req).setAttribute(Globals.REQ_PARAM_INCLUDE_HEAD,
                    head.getDataInTag().getBytes());
            }
        }else{
            ((HttpServletRequest) req).setAttribute(
    			Globals.REQ_PARAM_INCLUDE_BODY,
    			buff);
        }
//      2005.05.20 -end-
        
		//JSPȊÕRecsꂽꍇ͎sʂZbg
		//IncludeTagɂĎs邽
		//TODO:ÓIRecbytezŃZbgƂ܂\Ȃ
//      2005.05.20 -start-
//		if (contentsName!=null && !contentsName.endsWith(".jsp")) {
//			wrapper.getByteStream().reset();
//			wrapper.reset();
//			((HttpServletResponse) res).reset();
//		}
//      2005.05.20 -end-

		//CAEgpjsptH[h܂
		filterConfig.getServletContext().getRequestDispatcher(jsp).forward(
			req,
			res);
		
	}

	public void destroy() {
	}

	/**
	 * CN[h擾܂
	 * @param path NCAgvꂽNGXgURI
	 * @param req HttpServletRequestCX^X
	 * @return CN[h܂ރtH[hJSP
	 */
	private String layout(String path, HttpServletRequest req) {
		LayoutMappings mappings = LayoutMappings.getInstance();
		LayoutMapping include = (LayoutMapping) mappings.get(path);
		if (include == null) {
			//System.out.println("IncludeMapping is null.");
			return null;
		}

		String extendz = include.getExtendz();
		if (extendz != null) {
			//ẽCAEgvf܂
			checkParentLayout(include, req);
		}

		String layoutPath = include.getPath();
		HashMap putMap = include.getPuts();
		if (putMap != null) {

			//namepathHttpServletRequestɃZbg
			//ƂJSP̃^OCu<jsp:include page="${path}" />
			//Ăяo΂njI
			Set keySet = putMap.keySet();
			Iterator it = keySet.iterator();

			while (it.hasNext()) {
				String name = (String) it.next();

				LayoutPutMapping put = (LayoutPutMapping) putMap.get(name);
				//CN[hJSPt@CNGXgp[^ɃZbg
				req.setAttribute(Globals.REQ_PARAM_INCLUDE + name, put);

			}
		}

		return layoutPath;
	}

	/**
	 * ẽCAEg擾܂
	 * @param layout CAEg
	 * @param req HttpServletRequestCX^X
	 */
	private void checkParentLayout(
		LayoutMapping layout,
		HttpServletRequest req) {
		LayoutMappings mappings = LayoutMappings.getInstance();
		String parentName = layout.getExtendz();
		String extendz = layout.getExtendz();
		//Xɐe̗vfZbgĂȂ`FbN
		if (extendz != null) {
			LayoutMapping parent = (LayoutMapping) mappings.get(parentName);
			checkParentLayout(parent, req);
		}

		HashMap putMap = layout.getPuts();
		if (putMap == null) {
			return;
		}

		//CAEgpJSPɃCN[hJSPt@C擾A
		//HttpServletRequestCX^XɃZbg
		Set keySet = putMap.keySet();
		Iterator it = keySet.iterator();
		while (it.hasNext()) {
			String name = (String) it.next();

			LayoutPutMapping put = (LayoutPutMapping) putMap.get(name);
			//CN[hJSPt@CNGXgp[^ɃZbg
			//namepathHttpServletRequestɃZbg
			//ƂJSP̃^OCu<jsp:include page="${path}" />
			//Ăяo΂njI
			req.setAttribute(Globals.REQ_PARAM_INCLUDE + name, put);

		}

	}
}
