package org.itscool.commons.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class UrlUtil{
    /**
     * StringŋLqꂽL[[hkeyƔrΏƂƂȂstr
     * pX̔rs܂B<br>
     * rL[[hkeyɂ̓ChJ[hƂ"**"y"*"gp
     * Ƃł܂B<br>
     * "*"w肵ꍇURL"/"玟"/"܂ł̔Cӂ̕ɑ܂B<br>
     * "**"͔Cӂ̃fBNgKwɑ܂B<br>
     * "**"w肵ꍇ͍ŌɎw肳ꂽ"/"ȍ~̕񂪔ȓΏۂƂȂ܂<br>
     * <br>
     *yr̗z<br>
     * aaa/layout.do   aaa/layout.do             ͓ <br>
     * / *.do          /layout.do                ͓ <br>
     * / *.do          /servlet/layout.do        ͈Ⴄ<br>
     * /servlet/ *.do  /servlet/layout.do        ͓<br>
     * / * / *.do      /servlet/layout.do        ͓<br>
     * / * / *.do      /servlet/layout/layout.do ͈Ⴄ<br>
     * / * / * / *.do  /servlet/layout/layout.do ͓<br>
     * / ** / *.do     /servlet/layout/layout.do ͓<br>
     * / * /servlet/   /aaa/servlet/             ͓<br>
     * 
     * @param key rURLL[[h
     * @param str rΏƂƂȂURL
     * @return ȂtrueԂ܂
     */
    public static boolean isURLMatch(String key, String str){
        boolean ret = true;
        String stackKey = new String(key);
        String stackStr = new String(str);
        
        while(stackKey != null || stackKey.length() <= 0 ){
            // ŏ'/'ʒu
            int keyPartPos = stackKey.indexOf("/");
            int strPartPos = stackStr.indexOf("/");
            
            // "/"Ȃꍇ͕̒Zbg
            if( keyPartPos == -1){    
                keyPartPos = stackKey.length();
            }
            if( strPartPos == -1){
                strPartPos = stackStr.length();
            }
            
            //X^bN̐擪'/'܂ł̕擾
            String keyPart = stackKey.substring(0, keyPartPos);
            String strPart = stackStr.substring(0, strPartPos);
            
            if( keyPart.equals("**")){    //fBNg̃ChJ[hw肳ꂽꍇ
                keyPartPos = stackKey.lastIndexOf("/");
                strPartPos = stackStr.lastIndexOf("/");
                if( strPartPos == -1 ){
                	return false;
                }
                keyPart = stackKey.substring(keyPartPos, keyPartPos);
                strPart = stackStr.substring(strPartPos, strPartPos);
                
            }
            
            //X^bN̐擪'/'܂ł̕r
            ret = isPartMatch(keyPart, strPart);
            if(!ret){
                return false;
            }
            if( keyPartPos == stackKey.length()){
                return true;
            }
            stackKey = stackKey.substring(keyPartPos+1, stackKey.length());
            stackStr = stackStr.substring(strPartPos+1, stackStr.length());
        }
        
        return ret;
    }
    
    /**
     * ̒Prs܂<br>
     * "*"͔Cӂ̕񒷂̃ChJ[hƂȂ܂<br>
     * L[[h"*"܂܂Ăꍇ́A"*"ȍ~̃L[[hƂɈʒu
     * rΏƂ̕񂪓ł邩܂<br>
     * @param key rL[[h
     * @param str rΏƂƂȂ镶
     * @return ȂtrueԂ܂
     */
    private static boolean isPartMatch(String key, String str){
        boolean ret = true;
        char[] keyList = key.toCharArray();
        char[] strList = str.toCharArray();
        
        //ItZbg񒷂ɒB邩Ar镶̔茋ʂ
        //܂Ń[v
        for(int keyOffset=0, strOffset = 0; keyOffset<keyList.length; 
            keyOffset++, strOffset++){
            char c = keyList[keyOffset];
            if( c == '*'){    //ChJ[hw肳Ăꍇ
                //keyList̎c蕔strListɃZbgꂽkeyList
                //̎c蕔̃TCYr
                String keyPart = key.substring(keyOffset+1, key.length());
                int strPos = str.length() - keyPart.length();
                String strPart = str.substring(strPos, str.length());
                
                return keyPart.equals(strPart);
                
            }else{
            	if(keyOffset >= strList.length){
            		return false;
            	}
                //charm̔r
                if(keyList[keyOffset] != strList[strOffset]){
                    ret = false;
                    return ret;
                }
            }
        }
        
        return ret;
    }
    
    /**
     * NG[HashMapŎ擾܂
     * @param queryString NG[
     * @return NG[̔z
    */
    public static HashMap getQueryString(String queryString){
    	HashMap queryStrings = new HashMap();
    	
    	int startPos;
    	int equalPos;
    	int valuePos;
    	
    	if( queryString == null || queryString.length() == 0){
    		return queryStrings;
    	}
    	
    	while(queryString.length() > 0 ){
    		startPos = 0;
			equalPos = queryString.indexOf("=");
			valuePos = queryString.indexOf("&");
    	
	    	if( equalPos == -1 ){
	    		System.out.println("non query");
	    		return queryStrings;
	    	}
			if( valuePos == -1 ){
				valuePos = queryString.length();
			}
	    	
	    	String key = queryString.substring(startPos, equalPos);
			String value = queryString.substring(equalPos+1, valuePos);
			queryStrings.put(key, value);
    	    
			if( queryString.length() > valuePos ){
				queryString = queryString.substring(valuePos+1, queryString.length());
			}else{
				break;
			}
			
    	}
    	return queryStrings;
    }
    
    /**
	 * URLURL̂URLIuWFNg̐̂̂̏łB 
	 * vO͈ȉ̂悤ɂȂ܂ȒPłˁB
	 * 
	 * @param urlName URL
	 * @return URLCX^X
	 * @throws MalformedURLException
	 */
	public static URL getURLFromURLName(String urlName)
			throws MalformedURLException {

		return (new URL(urlName));
	}

	/**
	 * t@C t@CURLɕϊ̂ɂ͎኱̏KvłB 
	 * |Cg͈ȉ3_B pX̋؂L"/"ɕϊ
	 * ΃pXw肳ꂽƂɂ̓JgfBNgVXevpeB
	 * lĕ⊮ pX̐擪"/"邱Ƃۏ(WindowsΉ)
	 * vO͈ȉ̂悤ɂȂ܂B
	 * URL̃RXgN^MalformedURLExceptionX[̂͌
	 * URLw肳ꂽꍇŁA͂̃vÕoOȂ̂ŁA
	 * InternalErrorX[Ȃ悤ɂȂĂ܂B
	 * ̏ɂă\bhthrowsMalformedURLException
	 * OƂ\ɂĂ܂B
	 * 
	 * @param filename t@C
	 * @return URLCX^X
	 */
	public static URL getURLFromFileName(String filename) {
		try {
			char sep = File.separator.charAt(0);
			String file = filename.replace(sep, '/');
			if (file.charAt(0) != '/') {
				String dir = System.getProperty("user.dir");
				dir = dir.replace(sep, '/') + '/';
				if (dir.charAt(0) != '/') {
					dir = "/" + dir;
				}
				file = dir + file;
			}
			return (new URL("file", "", file));
		} catch (MalformedURLException e) {
			throw (new InternalError("can't convert from filename"));
		}
	}

	/**
	 * \[X \[XɑΉURLl邽߂ɂ
	 * java.lang.ClassgetResource\bhgp܂B
	 * \bhꔭł
	 * 
	 * @param resourceName \[X
	 * @param clazz NX
	 * @return URLCX^X
	 */
	public static URL getURLFromResourceName(String resourceName, Class clazz) {
		return (clazz.getResource(resourceName));
	}

	/**
	 * URL܂̓t@C URL܂̓t@Ĉꂪw肳ꂽ
	 * IɔʂURLɕϊ@\ƕ֗łB
	 * vÔ͎悤ɂȂ܂B 
	 * 
	 * @param name t@C
	 * @return URLCX^X
	 */
	public static URL getURLFromFileOrURLName(String name) {
		try {
			return (new URL(name));
		} catch (MalformedURLException e) {
		}
		return (getURLFromFileName(name));
	}

}
