package org.itscool.commons.util;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

/**
 * GR[fBOɊւ郆[eBeBNXł
 * @author kano
 */
public class StringUtil {
    /**
     * Unicode`̕u\\uE16iv`̕ɕϊ܂
     * @param str ϊΏۂƂȂ镶w肵Ă
     * @return u\\uE16iv`̕Ԃ܂
     */
    public static String encodeHex(String str){
        char[] buf1 = str.toCharArray();
        String buf2 = new String("");
        
        for (int i = 0; i < buf1.length; i++) {
            buf2 += "\\u" + (Integer.toString(buf1[i], 16)).toUpperCase();
        }
        return buf2;
    }
    
    /**
     * u\\uE16iv`̕Unicode`̕ɕϊ܂
     * @param unicodeStr ϊΏۂƂȂ镶w肵Ă
     * @return Unicode`̕̕Ԃ܂
     */
    public static String decodeHex(String unicodeStr){
        StringTokenizer st = new StringTokenizer(unicodeStr, "\\u");
        int tokenNum = st.countTokens();
        if(unicodeStr.indexOf("\\u") == -1){
            //HexŖ
            return unicodeStr;
        }
        char[] chars = new char[tokenNum];
        for( int i=0; i<tokenNum; i++ ){
            String str = st.nextToken();
            if( str == null || str.length() == 0 ){
                continue;
            }
            /* 16i쐬 */
            Integer integer = Integer.decode("0x" + str);
            chars[i] = (char)integer.intValue();
        }
        String newStr = new String(chars);
        return newStr;
    }
    
    /**
     * Unicode`̕u\\uE16iv`̕ɕϊ܂
     * @param byteData ϊΏۂƂȂ镶̃oCgf[^w肵Ă
     * @param encode GR[fBOw肵ĉ
     * @return u\\uE16iv`̕Ԃ܂
     */
    public static String encodeHex(byte[] byteData, String encode){
    	String str = "";
    	try{
    		str = new String(byteData, encode);
    	}catch(UnsupportedEncodingException uee ){
            uee.printStackTrace();
        }
        char[] buf1 = str.toCharArray();
        String buf2 = new String("");
        
        for (int i = 0; i < buf1.length; i++) {
            buf2 += "\\u" + (Integer.toString(buf1[i], 16)).toUpperCase();
        }
        return buf2;
    }
    
    /**
     * u\\uE16iv`̕Unicode`̕ɕϊ܂
     * @param unicodeStr ϊΏۂƂȂ镶w肵Ă
     * @return Unicode`̕̕Ԃ܂
     */
    public static byte[] decodeHex(String unicodeStr, String encode){
    	byte[] byteData = null;
    	String strData = decodeHex(unicodeStr);
        try{
            byteData = strData.getBytes("ISO-8859-1");
        }catch(UnsupportedEncodingException uee ){
            uee.printStackTrace();
        }
        return byteData;
    }
    /**
     * NGXgp[^̃tB^s܂B
     * @param value
     * @return tB^̃p[^Ԃ܂
     */
    public static String filter(String value){
        if( value== null ){
            return "";
        }
        
        StringBuffer result = new StringBuffer();
        for( int i=0; i<value.length(); i++){
            switch( value.charAt(i)){
                case '<' :
                    result.append("&lt;");
                    break;
                case '>' :
                    result.append("&gt;");
                    break;
                case '&' :
                    result.append("&amp;");
                    break;
                case '"' :
                    result.append("&quot");
                    break;
                default :
                    result.append(value.charAt(i));
                    
            }
        }
        return result.toString();
    }
    
    /**
     * w肳ꂽw肳ꂽGR[fBOɕϊ܂
     * @param str ϊΏۂƂȂ镶w肵Ă
     * @param encode GR[fBOw肵ĉ
     * @return ϊ̕
     */
    public static String convEncode(String str, String encode){
        try{
            str = new String(str.getBytes("ISO-8859-1"), encode);
        }catch(Exception e){
            
        }
        return str;
    }
    
    public static String convEncode(byte[] byteData, String encode){
    	String str = new String(byteData);
    	try{
    		str = new String(byteData, encode);
    	}catch(UnsupportedEncodingException uee){
    		uee.printStackTrace();
    	}
    	return str;
    }
    
}
