package org.itscool.commons.util;

public class NumberFormatUtil {
	public static String encodeMoneyString(String numStr){
		if (numStr == null || numStr.toString().length() == 0 ) {
			return numStr;
		}
		
		try{
    		//_ʒu擾
    		int pointIndex = numStr.indexOf(".");
    		String bodyStr = "";
    		String pointStr = "";
    		//_ȉʂ̕ϐɑޔ
    		if( pointIndex != -1 ){
    			pointStr = numStr.substring(pointIndex+1, numStr.length());
    			bodyStr = numStr.substring(0, pointIndex);
    		}else{
    			bodyStr = numStr;
    		}
    		Integer.parseInt(bodyStr);
    		if( bodyStr.length() <= 3){
    			return "\\" + numStr;
    		}
    		//for(int i=0; i<bodyStr.length(); i+=4){
    		int bodyLen = bodyStr.length();
    		String newStr=bodyStr.substring(bodyLen-3, bodyLen);
    		bodyStr = bodyStr.substring(0, bodyLen-3);
    		while(bodyLen > 4){
    			bodyLen = bodyStr.length();
				String next = bodyStr.substring(bodyLen-3, bodyLen);
				bodyStr = bodyStr.substring(0, bodyLen-3);
				newStr = next + "," + newStr;
    		}
    		if( bodyStr.length() > 0){
    			newStr = bodyStr + "," + newStr;
    		}
    		return "\\" + newStr;
    	}catch(NumberFormatException e){
    		return numStr;
    	}
	}
	
	public static String decodeMoneyString(String enNumStr){
		if( enNumStr == null || enNumStr.length() == 0){
			return enNumStr;
		}
		if(enNumStr.substring(0,1).equals("\\")){
			enNumStr = enNumStr.substring(1, enNumStr.length());
			enNumStr = enNumStr.replaceAll(",", "");
		}
		return enNumStr;
	}
	
	/**
	 * w肳ꂽ񂪐lɕϊ\肷
	 * @param str 蕶
	 * @return 蕶񂪐lϊ\ȏꍇtrueԂ܂
	 */
	public static boolean isNumber(String str){
		try{
			Long.parseLong(str);
			return true;
		}catch(NumberFormatException nfe ){
		}
		try{
			Double.parseDouble(str);
			return true;
		}catch(NumberFormatException nfe ){
		}
		
		return false;
	}
	
	
	
	/**
	 * w肵lɎw肵OpfBOsB<BR>
	 * ʂ͕ŕԂ
	 * @param num l
	 * @param keta 0pfBOs
	 * @return 0pfBO̕
	 */
	public static String convZeroPadding(int num, int keta){
		String numStr = String.valueOf(num);
		int numLen = numStr.length();
		if( numLen >= keta){
			return numStr;
		}
		for(int i=0; i<(keta-numLen); i++){
			numStr = "0"+numStr;
		}
		return numStr;
	}
	
	public static void main(String[] argv){
		System.out.println(encodeMoneyString("10.1"));
		System.out.println(encodeMoneyString("1.2"));
		System.out.println(encodeMoneyString("aaa"));
		System.out.println(encodeMoneyString(null));
		System.out.println(encodeMoneyString("1234"));
		System.out.println(encodeMoneyString("123456789"));
		System.out.println(encodeMoneyString("123456789.1234567"));
		System.out.println(decodeMoneyString("\\9,999"));
		System.out.println(decodeMoneyString("\\9,999,999,999.999"));
		System.out.println(convZeroPadding(100, 4));
		System.out.println(convZeroPadding(100, 10));
		System.out.println(convZeroPadding(100, 2));
		
	}
}
