package org.itscool.commons.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

/**
 * tR|[lgp[eBeBNXł
 */
public class DateFormatUtil {
	private static final int[] DAY_OF_KIND = { 4, 6, 9, 11 };
	
	/**
	 * ̓擾܂
	 * @param cal CalendarCX^X
	 * @return ̓
	 */
	public static int getMaxDay(Calendar cal){
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		
		if(month==2){
			if( (year%4==0 && year%100!=0) || (year%400==0) ){
				return 29;
			}else{
				return 28;
			}
		}
		
		for(int i=0; i<DAY_OF_KIND.length; i++){
			if( DAY_OF_KIND[i] == month){
				return 30;
			}
		}
		return 31;
	}
	
	/**
	 * 挎̍ŏIT̓jCalendarCX^XŎ擾
	 * @param year N
	 * @param month 
	 * @param firstYobi N 
	*/
	public static Calendar getLastMonthWeek(int year, int month ){
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month-1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		int firstYobi = cal.get(Calendar.DAY_OF_WEEK);
		cal.add(Calendar.DAY_OF_MONTH, -( firstYobi-1 ));
		return cal;
	}
    
	/**
     * ݓyy/mm/dd`Ŏ擾܂
     * 
     * @return ݓyy/mm/ddŕԂ܂
     */
    public static String encodeYYMMDDString(){
        Calendar cal = Calendar.getInstance();
        return encodeYYMMDDString(cal);
    }
    
    
    /**
     * wyy/mm/dd`Ŏ擾܂
     * @param cal CalendarCX^X
     * @return wyy/mm/ddŕԂ܂
     */
    public static String encodeYYMMDDString(Calendar cal){
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH)+1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        
    	String yearStr = String.valueOf(year).substring(2, 4);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        
        return ret;
    }
    
    /**
     * ݓyyyy/mm/dd`Ŏ擾܂
     * 
     * @return ݓyyyy/mm/ddŕԂ܂
     */
    public static String encodeYYYYMMDDString(){
    	Calendar cal = Calendar.getInstance();
        return encodeYYYYMMDDString(cal);
    }
    
    /**
     * wyyyy/mm/dd`Ŏ擾܂
     * @param cal CalendarCX^X
     * @return wyyyy/mm/ddŕԂ܂
     */
    public static String encodeYYYYMMDDString(Calendar cal){
    	int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH)+1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        
    	String yearStr = String.valueOf(year);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        
        return ret;
    }
    
    /**
     * yyyy/mm/dd`̕CalendarCX^Xɕϊ܂
     * @param yyyymmdd
     * @return
     */
    public static Calendar decodeYYYYMMDDString(String yyyymmdd){
    	GregorianCalendar cal = new GregorianCalendar(); 
    	cal.clear();
    	try{
    		StringTokenizer dataSt = new StringTokenizer(yyyymmdd, "/");
            dataSt.hasMoreTokens();
            int year = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int month = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int day = Integer.parseInt(dataSt.nextToken());
            cal.set(Calendar.YEAR, year);
            cal.set(Calendar.MONTH, month - 1 );
            cal.set(Calendar.DAY_OF_MONTH, day);
            return cal;
    	}catch(Exception e){
    		return null;
    	}
    }
    
    /**
	 * w肳ꂽCalendarCX^Xɕϊ\肷
	 * @param str 蕶iyyyy/mm/dd`j
	 * @return 蕶񂪐lϊ\ȏꍇtrueԂ܂
	 */
	public static boolean isCalendar(String str){
		Calendar cal = decodeYYYYMMDDString(str);
		if( cal != null ){
			return true;
		}else{
			return false;
		}
	}
	
}
