package org.itscool.commons.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * L[f[^擾NX<BR>
 * vpeBt@CL[[hɊYl擾B
 * @author [
 * @version 1.00A 2001/03/24 VK쐬
 * @since jdk1.4.1
*/
public class PropertyFile{
    /** vpeBt@C̃Rgs\g[N */
    public static final String PROPERTIES_COMMENT_KEY = "#";
    
    /** ʃXg*/
    protected Hashtable dataList;
    private String path;
    private String commentKey;
    
    /**
     * vpeBt@C̏s܂
     * @param path vpeBt@C܂ރpX
     * @throws IOException
     */
    public PropertyFile(String path) throws IOException{
        dataList = new Hashtable();
        this.path = path;
        this.commentKey = PROPERTIES_COMMENT_KEY;
        this.load();
    }
    
    /**
     * f[^쐬
     * @throws Exception, IOException : sAt@CI[vG[
    */
    public void load() throws IOException{
        String buff     = commentKey;
        
        FileReader frIn = null;
        try{
            frIn = new FileReader( path );
        }catch( FileNotFoundException fnfe ){
            return;
        }
        
        BufferedReader brIn = new BufferedReader( frIn );
        dataList.clear();
        
        while(buff != null){
            buff = brIn.readLine();
            
            if( buff == null ){
                continue;
            }
            
            if( buff.startsWith( commentKey, 0 ) ){
                continue;
            }
            
            // 񂩂"="
            int index = buff.indexOf( "=" );
            if( index == -1 ){
                continue;
            }
                
            // "="ȑO̕擾
            String key = buff.substring(0,index );
            key = key.trim();
            
            // "="ȍ~̕擾
            String data = buff.substring( index + 1 );
            data = data.trim();
            
            dataList.put(key, data);
        }
        
        frIn.close();
        brIn.close();
    }
    
    /**
     * vpeB擾܂<BR>
     * @param key vpeB
     * @return vpeBString`ŕԂ܂
     * @throws IOException
     */
    public String read(String key){
        String data = (String)dataList.get(key);
        return data;
    }
    
    /**
     * dataŎw肳ꂽkeyŎw肳ꂽvpeBɏ݂܂
     * @param key vpeB
     * @param data vpeBɃZbg镶
     * @param append ǉ[hBtruew肳ꂽꍇ͊̃vpeBt@Cɒǉ܂
     * @return vpeB̒ǉɐꍇtrueԂ܂B̃vpeBɑ݂
     * ꍇfalseԂ܂
     * @throws IOException
     */
    public boolean write(String key, String data, boolean append)throws IOException{
        if( read(key) != null ){
            //L[݂ꍇ
            return false;
        }
        if( !append ){
            dataList.clear();
        }
        dataList.put(key, data);
        out(key, data, append);
        return true;
    }
    
    /**
     * dataŎw肳ꂽkeyŎw肳ꂽvpeBɏ݂܂
     * @param key vpeB
     * @param data vpeBɃZbg镶
     * @param append ǉ[hBtruew肳ꂽꍇ͊̃vpeBt@Cɒǉ܂
     * @return vpeB̒ǉɐꍇtrueԂ܂B̃vpeBɑ݂
     * ꍇfalseԂ܂
     * @throws IOException
     */
    protected synchronized void out(String key, String data, boolean append ) throws IOException{
        FileOutputStream out = new FileOutputStream(path, append);
        String line = System.getProperty("line.separator");
        //t@C̓eXV
        out.write(key.getBytes());
        out.write((new String(" = ")).getBytes());
        out.write(data.getBytes());
        out.write(line.getBytes());
        //t@C
        out.close();
        
    }
    
    /**
     * w肳ꂽvpeB폜܂B
     * @param delKey vpeBw肵܂
     * @return vpeB̍폜ɐꍇtrueԂ܂
     * @throws IOException
     */
    public boolean delete(String delKey) throws IOException{
        if( isFile(path) ){
            load();            //t@C[h
        }else{
            return false;
        }
        if( dataList.get(delKey) != null ){
	        dataList.remove(delKey);        //z񂩂vf폜
	        upFile();        //t@C㏑
        }
        return true;
    }
    
    /**
     * ̃vpeBt@Cɓo^ĂvpeB
     * Sč폜܂
    */
    public void removeAll(){
        if( isFile(path) ){
            delFile(path);
        }
        dataList.clear();
    }
    
    /**
     * BinaryPropertyFileCX^Xt@CɍXV܂
     * @throws IOException
     */
    protected void upFile() throws IOException{
    	if( dataList.size() == 0 ){
    		delFile(this.path);
    	}else{
	        for( Enumeration enumObj = dataList.keys();
	        enumObj.hasMoreElements(); ){
	            String key = ( String )enumObj.nextElement();
	            String data    = read(key);
	            out(key, data, true);
	        }
    	}
    }
    
    /**
     * w肳ꂽpXt@Cł邩`FbN܂
     * @param path t@CpX
     * @return w肳ꂽpXt@C̏ꍇtrueԂ܂
     */
    protected boolean isFile(String path){
        File file = new File( path  );

        return file.canRead();
        
    }
    
    /**
     * w肳ꂽt@C폜܂
     * @param path t@CpX
     */
    protected synchronized void delFile(String path){
        File file = new File( path  );
        file.delete();
    }
    
    /**
     * vpeB̌擾܂
     * @return vpeB
     */
    public int size(){
        return dataList.size();
    }
    
    /** 
     * debug L[ƃf[^̃XgԂB
     * @return String : L[ƃf[^̃Xg
    */
    public String toString(){
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for( Enumeration enumObj = dataList.keys();
        enumObj.hasMoreElements(); ){
            String key = ( String )enumObj.nextElement();
            String data    = 
                ( String )dataList.get(key);
            sb.append( "[KEY-->" + key + "] [DATA--->" + data );
            sb.append( line);
        }
        return sb.toString();
    }

	public Hashtable getDataList() {
		return dataList;
	}
}
