package org.itscool.commons.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

/**
 * VvȃMO[eBeBNXł<br>
 * ̃NX͎Ɉȉ̋@\񋟂܂B<br>
 * (1) O[eCg<br>
 *@@o͂郍Ot@C̃TCYwTCY𒴂Ɠtt̊gq
 *    ŃÕobNAbvs܂B<br>
 *<br>
 * (2) Ox̐؂蕪<br>
 *@@ȉ̃xŃȌo̓x؂ւ鎖o܂B<br>
 *@@@ fobOFDEBUG<br>
 *@@A CtH[VFINFO<br>
 *@@B xFWORN<br>
 *@@C G[FERROR<br>
 *<br>
 * (3) o̓[h̐؂蕪<br>
 *@@ȉ̃[hŃȌo̓[h؂ւ鎖ł܂B<br>
 *@@@ R\[óFDISP_MODE<br>
 *@@A t@CóFFILE_MODE<br>
 *@@B R\[/t@CóFALLOUT_MODE<br>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2000/03/02
*/
public class Log extends AbstractLog{
    private static Log log = null;
     
    
    /**
     * LogCX^X擾܂
     * @return LogCX^XԂ܂
    */
    public static synchronized Log getInstance(){
        if( log == null ){
            log = new Log();
        }
        return log;
    }
    
    /**
     * [yyyy/mm/dd/HH:MM:SS:mmmmmm]]level[LEVEL]class:[CLASS]method:[METHOD]msg[MSG]
     * `̃Oo͂܂B<br>
     * out\bhďoƂ̃NXThrowable().getStackTrace()\bhg
     * ďoƂ̃NXƃ\bh܂<br>
     *
     * @param logMsg O
     * @param levelNow Ȍo̓x
    */
    public synchronized void out(String logMsg, String levelNow){
        CallClass call = new CallClass(3);  //3ŌŒI
        String clazz = call.getClassName();
        String func = call.getMethodName();
        
        //Ȍo̓x̃`FbN
        if( this.levelInt >= getLevelNum(levelNow) ){
            return;
        }
        try{
            if( mode.equals(FILE_MODE) ){
                outFile( clazz, func, logMsg, levelNow );
            }else if( mode.equals(DISP_MODE) ){
                outDisp( clazz, func, logMsg, levelNow );
            }else if( mode.equals(ALLOUT_MODE)){
                outFile( clazz, func, logMsg, levelNow );
                outDisp( clazz, func, logMsg, levelNow );
            }else{
            	outDisp( clazz, func, logMsg, levelNow );
            }
        }catch( IOException ioe ){
            throw new LogRuntimeException(ioe.getMessage());
        }
    }
    
//    /**
//     * [yyyy/mm/dd/HH:MM:SS:mmmmmm]]level[LEVEL]class:[CLASS]method:[METHOD]msg[MSG]
//     * `̃OINFOxŏo͂܂B<br>
//     * out\bhďoƂ̃NXThrowable().getStackTrace()\bhg
//     * ďoƂ̃NXƃ\bh܂<br>
//     *
//     * @param logMsg O
//    */
//    public static void outConsole(String logMsg){
//        CallClass call = new CallClass(1); 
//        String clazz = call.getClassName();
//        String func = call.getMethodName();
//        
//        outDisp( clazz, func, logMsg, Log.INFO );
//    }
        
    /**
     * Ot@Cɏo͂܂B
     *
     * @param clazz out\bhďoNX
     * @param func out\bhĂяo\bh
     * @param logMsg O
     * @param levelNow Ȍo̓x
    */
    private void outFile(String clazz, String func, String logMsg, String levelNow)
    throws IOException{
        if( maxSize <= 0 ){
        	outDisp( clazz, func, logMsg, levelNow );
        	outDisp( Log.class.getName(), "outFile()", "t@C̏o̓TCYOł", ERROR );
        	return;
        }
        
        //Ot@C̃TCY`FbN 
        sizeCheck();
        //t@CI[v
        //RandomAccessFile raf = new RandomAccessFile( logPath , "rw" );
        //t@C̍Ōֈړ
        //raf.seek( raf.length());
        //bZ[W̏ 
        //raf.writeBytes(Log.getMsg( clazz, func, logMsg, levelNow));
        //t@CN[Y
        //raf.close();
        Writer w = new OutputStreamWriter(new FileOutputStream(logPath, true), encode);
        w.write(Log.getMsg( clazz, func, logMsg, levelNow));
        w.close();
    }
    
    /**
     * OR\[ɏo͂܂B
     *
     * @param clazz out\bhďoNX
     * @param func out\bhĂяo\bh
     * @param logMsg O
     * @param levelNow Ȍo̓x
    */
    private static void outDisp(String clazz, String func, String logMsg, String levelNow){
		
        System.out.print(getMsg(clazz, func, logMsg, levelNow));
    }
    
    /**
     * bZ[WO̎擾
     * @param clazz    vZX
     * @param func     ֐
     * @param logMsg   ObZ[W
     * @param levelNow Oo̓x
     * @return log     쐬̃ObZ[W
     *
    */
    protected static String getMsg( String clazz, String func, String logMsg, String levelNow ){
        StringBuffer log = new StringBuffer();
        log.append(Log.getNowDate());
        log.append(" ").append(getLogKind(levelNow)).append(" ");
        log.append(clazz).append(" ");
        log.append(func).append("() ");
        log.append(logMsg);
        log.append(System.getProperty( "line.separator" )); 
        return log.toString();
    }
}

/**
 * NXyу\bȟďo肵AďoNXƃ\bhێ
 * NXłB
 *
 * ̃NXThrowable().getStackTrace()\bhɂStackTraceElement
 * 쐬A̔z񂩂ĂяoꂽNXƃ\bh擾܂B
 *
 * ̃\bhjavão[W1.4ȏŃT|[gĂ܂B 
 *
 *ygpz
 *      StackTraceElement[] traces = new Throwable().getStackTrace();
 *      for( int i=0; i<traces.length; i++ ){
 *          StackTraceElement trace = traces[i];
 *          String className = trace.getClassName();
 *          String methodName = trace.getMethodName();
 *       }
 *
*/
class CallClass{
	/** ďoƂ̃NX */
	private String className = Log.class.getName();
	/** ďoƂ̃\bh */
	private String methodName = "out";
    
	/**
	 * ďoƂ̃NXyу\bh擾܂B
	 *
	 * @record ďoƂ̃\bh肷邽߂Ɏw肵܂B
	 *         \bhďo̗ʂw肵ĂB
	*/
	public CallClass(int record){
		StackTraceElement[] traces = new Throwable().getStackTrace();
		if( traces.length >= record ){
			StackTraceElement trace = traces[record];
			String clazzName = trace.getClassName();
			String methodName = trace.getMethodName();
			setClassName(clazzName);
			setMethodName(methodName);
		}
	}
    
	/** 
	 * ďoƂ̃NX擾܂
	*/
	public String getClassName(){
		return className;
	}
    
	/** 
	 * ďoƂ̃NXݒ肵܂
	*/
	public void setClassName(String className){
		this.className = className;
	}
    
	/** 
	 * ďoƂ̃\bh擾܂
	*/
	public String getMethodName(){
		return methodName;
	}
    
	/** 
	 * ďoƂ̃\bhݒ肵܂
	*/
	public void setMethodName(String methodName ){
		this.methodName = methodName;
	}
}


