package org.itscool.commons.file;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * RtBOt@CǂݍރNX<BR>
 * XMLhLgǂݏo{ۃNXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public abstract class ConfigReader {
	protected Log log = Log.getInstance();
    protected File xmlFile;
    protected DocumentBuilderFactory factory;
    protected DocumentBuilder builder;
    protected Document document;
    protected String configName;
	
	public String getConfigName(){
		return configName;
	}
	
	public void setConfigName(String configName ){
		this.configName = configName;
	}
	
	public void create(HashMap nodeList ) throws IOException{
    	ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
		URL url = parent.getResource(configName);
	    //URL url = ConfigReader.class.getResource(fileName);
		if( url == null ){
			throw new IOException(configName + " is not found.");
		}
		log.info("load config is " + url.getFile());
		create(url.getFile(), nodeList);
    }
	
	public void create(LinkedList nodeList ) throws IOException{
    	ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
		URL url = parent.getResource(configName);
	    //URL url = ConfigReader.class.getResource(fileName);
		if( url == null ){
			throw new IOException(configName + " is not found.");
		}
		log.info("load config is " + url.getFile());
		create(url.getPath(), nodeList);
    }
    
    /**
     * DocumentBuildergXMLt@Cǂݍ݂܂
     * @param path RtBOt@C̃pXw肵܂
     * @param nodeList ǂݍDOMi[CX^Xw肵܂
     * @throws Exception t@C̓ǂݍ݂Ɏsꍇ͗OExceptionX[܂
     */
    public void create(String path, HashMap nodeList ) throws IOException{
    	File xmlFile = new File( path );
        if( !xmlFile.isFile()) {
            String err = "Can not found file at config file(" + path +")";
            throw new IOException(err);
        }
        try{
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
			//G[Enh̓o^
			builder.setErrorHandler(new MyHandler());
            document = builder.parse ( xmlFile);    //hLg
        }catch( Exception e){
            throw new IOException(e.getMessage());
        }
        doCreate(nodeList);
    }
    
    /**
     * DocumentBuildergXMLt@Cǂݍ݂܂
     * @param path RtBOt@C̃pXw肵܂
     * @param nodeList ǂݍDOMi[CX^Xw肵܂
     * @throws Exception t@C̓ǂݍ݂Ɏsꍇ͗OExceptionX[܂
     */
    public void create(String path, LinkedList nodeList ) throws IOException{
        File xmlFile = new File( path );
        if( !xmlFile.isFile()) {
            String err = "[" + path + "]" + 
                "Can not found file  at config file(" + 
                ConfigReader.class.getName()+")";
            throw new IOException(err);
        }
        try{
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
			//G[Enh̓o^
			builder.setErrorHandler(new MyHandler());
            document = builder.parse ( xmlFile);    //hLg
        }catch( SAXException e){
			throw new IOException(e.getMessage());
			
		}catch( Exception e){
            throw new IOException(e.getMessage());
        }
        doCreate(nodeList);
    }
    /**
     * XMLt@Cvf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param nodeList XML̉͌
    */
    protected void doCreate(HashMap nodeList) throws IOException{}
    
    /**
     * XMLt@Cvf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param nodeList XML̉͌
    */
    protected void doCreate(LinkedList nodeList) throws IOException{}
}

/**
 * Xg1ł̓p[T̃G[OŃLb`悤Ƃ܂AXMLp[T̃G[̓CxgƂĔ
 * ̂ŁAG[EnhƂdg݂Ŏ舵Ƃł܂B
 * G[Enh́AC^tF[Xorg.xml.sax.ErrorHandler邱ƂŁAAvP[Vŗp
 * ܂B
 * 
 * `Ă郁\bh͕\2̎OłB
 * 
 * \2. ErrorHandler̃\bh ߂l^ \bh(Xg) Tv 
 * void error(SAXParseException exception)      ͌p\ȃG[BÓᔽB 
 * void fatalError(SAXParseException exception) ͌ps\Ȑ[ȃG[B`ᔽB 
 * void warning(SAXParseException exception)    xB 
 * 
 * C^tF[XErrorHandler̎NXƂāAorg.xml.sax.helpers.DefaultHandlergƂ\
 * B
 * NXDefaultHandleŕAC^tF[XErrorHandler̂قɁAContentHandler, DTDHandler, Entity
 * Resolver̃\bhĂÃNXp邱ƂŁAsvȃ\bh̎ȗ邱Ƃ
 * ł܂B
 * @author kano
 */
class MyHandler implements ErrorHandler {
	public void warning(SAXParseException e) throws SAXException{
		String err = "x: " + e.getLineNumber() +"s";
		err += "[" + e.getMessage() + "]";
		
		throw new SAXException(err);
	}
	public void error(SAXParseException e) throws SAXException{
		String err = "G[: " + e.getLineNumber() +"s";
		err += "[" + e.getMessage() + "]";
		
		throw new SAXException(err);
	}
	public void fatalError(SAXParseException e) throws SAXException{
		String err = "[ȃG[: " + e.getLineNumber() +"s";
		err += "[" + e.getMessage() + "]";
		
		throw new SAXException(err);
	}
}

