package org.itscool.commons.daotool.data;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.itscool.commons.daotool.MappingToolException;

/**
 * POIgExcelō쐬e[udl[h܂<br>
 * 
 * <hr><br>
 * POIƂ
 * <hr><br>
 * POIƂApache JakartavWFNg̃TuvWFNgŁAMicrosoft
 *  OLE2hLg`ɊÂ܂܂ȃt@C`Java
 * 삷邽߂APISł<br>
 * ł́APOI񋟂HSSFR|[lggXLSXvbhV
 * [g̏ǂݍޏĂ܂<br>
 * <hr><br>
 * HSSFR|[lgƂ
 * <hr><br>
 * XLSXvbhV[g쐬^CAǂݏ@\񋟂Ă܂B<br>
 * Microsoft Excel97/2000̃t@C`ɑΉĂ܂<br>
 * HSSFR|[lg̊{\͈ȉ̂Ƃł<p>
 * <table>
 *   <tr>
 *     <td>[NubN<td>
 *     <td>org.apache.poi.hssf.usermodel.HSSFWrokbook</td>
 *   </tr>
 *   <tr>
 *     <td>V[g<td>
 *     <td>org.apache.poi.hssf.usermodel.HSSFSheet</td>
 *   </tr>
 *   <tr>
 *     <td>siRow)<td>
 *     <td>org.apache.poi.hssf.usermodel.HSSFRow</td>
 *   </tr>
 *   <tr>
 *     <td>ZiCell)<td>
 *     <td>org.apache.poi.hssf.usermodel.HSSFCell</td>
 *   </tr>
 * </table>
 * <p>
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/12/26
 */
public class DbPropertyReader{
	/** DBdlǗLinkedListCX^X */
//	private LinkedList tableMap;
    private HashMap tableMap;
    /** NXEpbP[W̊Jns */
    private int startClassRow = 0;
    /** NXTv̊Jns */
    private int startNoteRow = 1;
    /** e[ůJns */
    private int startTableRow = 2;
    /** hLg̊Jns */
    private int startInfoRow = 3;
    /** tB[hp[^̊Jns */
    private int startParamRow = 6;
	
	/**
	 * DbPropertyReadeȑ
	 */
	public DbPropertyReader(){
//		tableMap = new LinkedList();
	    tableMap = new HashMap();
	}
	
	/**
	 * XLS`DBdle[uyуNX[h
	 * ܂
	 * @param path DBdl̕ۊǐ
	 * @param sheetNo ǂݎJñV[gio[
	 * @return DBdl璊oꂽe[uƃNX
	 * ̃XgԂ܂
	 */
//	public LinkedList create(String path) throws Exception{
	public HashMap create(String path, int sheetNo) throws Exception{
		POIFSFileSystem fs = new POIFSFileSystem(
				new FileInputStream(path));
		HSSFWorkbook workbook = new HSSFWorkbook(fs);
		if(tableMap.size() > 0){
			tableMap.clear();
		}
		
		int sheetNum = workbook.getNumberOfSheets();
		
		for(int i=sheetNo; i<sheetNum; i++){
			HSSFSheet sheet = workbook.getSheetAt(i);
			if( sheet.getLastRowNum() == 0){	//V[g̏ꍇ
				continue;
			}
			
			DbPropertyList propertyMap = createpropertyMap(sheet, i);	
//			tableMap.add(propertyMap);
			tableMap.put(propertyMap.getTableName(), propertyMap);
			
		}
		
		//OQƏ̐ݒ
		Set keySet = tableMap.keySet();
		Iterator it = keySet.iterator();
		while(it.hasNext()){
		    Object key = it.next();
		    DbPropertyList propertyList = (DbPropertyList)tableMap.get(key);
		    String tableName = propertyList.getTableName();
		    
		    System.out.println("\n");
		    System.out.println("====================================================================================================================");
		    System.out.println("y" + tableName + "̃e[u z\n");
		    System.out.println(propertyList.toString());
		    
		    Set propertyKeySet = propertyList.keySet();
		    Iterator propertyIt = propertyKeySet.iterator();
		    System.out.println("[vpeB]");
		    
		    //DbPropertyList newFkPropertyList = null;
            
		    while(propertyIt.hasNext()){
		        Object propertyKey = propertyIt.next();
		        DbProperty property = (DbProperty)propertyList.get(propertyKey);
		        String fkTableName = property.getForeignTable();
		        String fkFieldName = property.getForeignKey();
		        String fkPropertyName = property.getForeignPropertyName();
		        
		        System.out.println("Property "+property.toString());
		        
		        //OQƃL[ZbgĂꍇ
		        if(fkTableName != null && fkTableName.length() > 0){
		            DbPropertyList fkPropertyList = (DbPropertyList)tableMap.get(fkTableName);
		            if( fkPropertyList == null ){
		            	String err = "e[u[" + tableName + "]ɒ`ꂽOQƏ[" + fkTableName + "]܂ł";
		            	throw new NullPointerException(err);
		            }
		            String propertyName = property.getPropertyName();
		            System.out.print("  [" + propertyName + "̊OQƏ] [" + fkTableName + "][" + fkFieldName + "]");
		            System.out.print(" pkg:"+fkPropertyList.getPkgName());
		            System.out.print(" class:"+fkPropertyList.getClassName());
		            System.out.print(" fkProperty:"+fkPropertyName);
		            System.out.println(" property:"+propertyName);
		            
		            DbPropertyList newFkPropertyList = propertyList.getFkPropertyList(fkTableName);
		            if( newFkPropertyList == null ){
		                //OQƏ݂̂DbPropertyList쐬
		                newFkPropertyList = new DbPropertyList();
		                newFkPropertyList.setPkgName(fkPropertyList.getPkgName());
		                newFkPropertyList.setClassName(fkPropertyList.getClassName());
		                newFkPropertyList.setAuthor(fkPropertyList.getAuthor());
		                newFkPropertyList.setTableName(fkPropertyList.getTableName());
		                newFkPropertyList.setRefName(fkPropertyName);
		                //OQƏo^
		                propertyList.addFkPropertyList(newFkPropertyList);
		            }
		            DbProperty newFkProperty = new DbProperty();
		            newFkProperty.setFieldName(fkFieldName);
		            newFkProperty.setPropertyName(propertyName);
		            newFkProperty.setForeignPropertyName(fkPropertyName);
		            newFkPropertyList.addProperty(fkFieldName, newFkProperty);
		            //property.addLinkFkPropertyList(linkFkPropertyList);
		        }
		    }
		}
		
		return tableMap;
	}
	
	/**
	 * e[uƃNX̊֘A쐬܂
	 * @param sheet e[uƃNX̊֘ALڂ
	 * HSSFSheetCX^X
	 * @param sheetNo V[gԍ
	 * @return DbPropertyListCX^XԂ܂
	 */
	public DbPropertyList createpropertyMap(HSSFSheet sheet, int sheetNo){
		HSSFRow row0 = sheet.getRow(startClassRow);
		HSSFCell pkgCell = row0.getCell((short)1);
		HSSFCell clazzCell = row0.getCell((short)9);
		
		HSSFRow row1 = sheet.getRow(startNoteRow);
		HSSFCell noteCell = row1.getCell((short)1);
		
		//add 2005/09/27 start
		//NX̐tO擾
		HSSFCell createClassCell = row1.getCell((short)9);
		//add 2005/09/27 end
		
		HSSFRow row2 = sheet.getRow(startTableRow);
		HSSFCell tableCell = row2.getCell((short)1);
		//add 2006/03/03 start
		HSSFCell createDaoCell = row2.getCell((short)9);
		//add 2006/03/03 end 
		
		HSSFRow row3 = sheet.getRow(startInfoRow);
		HSSFCell authorCell = row3.getCell((short)1);
		HSSFCell dateCell = row3.getCell((short)9);
		
		String pkg = CellUtil.getStringCellValue(pkgCell);
		String clazz = CellUtil.getStringCellValue(clazzCell);
		String note = CellUtil.getStringCellValue(noteCell);
		String author = CellUtil.getStringCellValue(authorCell);
		String date = CellUtil.getStringCellValue(dateCell);
		String table = CellUtil.getStringCellValue(tableCell);
		
		//add 2005/09/27 start
		boolean createClass = CellUtil.getBooleanCellValue(createClassCell);
		//add 2005/09/27 end
		//add 2006/03/03 start
		boolean createDao = CellUtil.getBooleanCellValue(createDaoCell);
		//add 2006/03/03 end 
		if(pkg == null || pkg.length() == 0 ){
		    throw new MappingToolException("pbP[WZbgĂB" +
		    	"V[gԍ[" + sheetNo + "]");
		}
		if(clazz == null || clazz.length() == 0 ){
		    throw new MappingToolException("NXZbgĂB" + 
		    	"V[gԍ[" + sheetNo + "]");
		}
		if(table == null || table.length() == 0 ){
		    throw new MappingToolException("e[uZbgĂB" +
		    	"V[gԍ[" + sheetNo + "]");
		}
		DbPropertyList propertyMap = new DbPropertyList();
		propertyMap.setPkgName(pkg);
		propertyMap.setClassName(clazz);
		propertyMap.setNote(note);
		propertyMap.setAuthor(author);
		propertyMap.setDate(date);
		propertyMap.setTableName(table);
		//add 2005/09/27 start
		propertyMap.setCreateClassFlg(createClass);
		//add 2005/09/27 end
		//add 2006/03/03 start
		propertyMap.setCreateDaoFlg(createDao);
		//add 2006/03/03 end
		System.out.println("ǎJne[u      "+propertyMap.getTableName());
		for( int i=startParamRow; i<=sheet.getLastRowNum(); i++ ){
			DbProperty property = createParamater(sheet.getRow(i), sheetNo, i);
			if( ( property.getPropertyName() == null || property.getPropertyName().length() == 0 )
			  && ( property.getPropertyType() == null || property.getPropertyType().length() == 0)
			  && ( property.getFieldName() == null || property.getFieldName().length() == 0) 
			  && ( property.getFieldType() == null || property.getFieldType().length() == 0)){
			    //`ĂȂR[h͏OΏۂƂ
			    continue;
			}else if(property.getPropertyName() == null || property.getPropertyName().length() == 0 ){
			    throw new MappingToolException("vpeBZbgĂB" +
			    	" V[gԍ[" + sheetNo + "]" + 
			    	" sԍ[" + i + "]");
			}else if(property.getFieldName() == null || property.getFieldName().length() == 0){
			    throw new MappingToolException("tB[hZbgĂB" + 
			    	" V[gԍ[" + sheetNo + "]" + 
			    	" sԍ[" + i + "]");
			}else if(property.getFieldType() == null || property.getFieldType().length() == 0){
			    throw new MappingToolException("tB[h^CvZbgĂB"+ 
			    	" V[gԍ[" + sheetNo + "]" + 
			    	" sԍ[" + i + "]");
			}else if(property.getPropertyType() == null || property.getPropertyType().length() == 0){
			    throw new MappingToolException("vpeB^CvZbgĂB" + 
			    	" V[gԍ[" + sheetNo + "]" + 
			    	" sԍ[" + i + "]");
			}
//			propertyMap.add(property);
			propertyMap.addProperty(property.getFieldName(), property);
		}
		return propertyMap;
	}
	
	/**
	 * e[ũtB[hƃNX̃vpeBƂ̊֘A
	 * 쐬܂
	 * @param row e[ũtB[hƃNX̃vpeB
	 * Ƃ̊֘A񂪋LqꂽHSSFRowCX^X
	 * @param sheetNo V[gԍ
	 * @param rowNo sԍ
	 * @return DbPropertyCX^XԂ܂ 
	 */
	public DbProperty createParamater(HSSFRow row, int sheetNo, int rowNo){
		HSSFCell propertyNameCell = row.getCell((short)0);
		HSSFCell propertyTypeCell = row.getCell((short)1);
		HSSFCell fieldNameCell = row.getCell((short)2);
		HSSFCell fieldTypeCell = row.getCell((short)3);
		HSSFCell fieldDefCell = row.getCell((short)4);
		HSSFCell fieldNonCell = row.getCell((short)5);
		HSSFCell fieldSizeCell = row.getCell((short)6);
		HSSFCell primaryCell = row.getCell((short)7);
		HSSFCell fTableCell = row.getCell((short)8);
		HSSFCell fKeyCell = row.getCell((short)9);
		HSSFCell fPropertyNameCell = row.getCell((short)10);
		HSSFCell noteCell = row.getCell((short)11);
		
		String propertyName = CellUtil.getStringCellValue(propertyNameCell);
		String propertyType = CellUtil.getStringCellValue(propertyTypeCell);
		String fieldName = CellUtil.getStringCellValue(fieldNameCell);
		String fieldType = CellUtil.getStringCellValue(fieldTypeCell);
		String fieldDef = CellUtil.getStringCellValue(fieldDefCell);
		int fieldSize = (int)CellUtil.getNumericCellValue(fieldSizeCell);
		boolean fieldNon = CellUtil.getBooleanCellValue(fieldNonCell);
		boolean primary = CellUtil.getBooleanCellValue(primaryCell);
		String foreignTable = CellUtil.getStringCellValue(fTableCell);
		String foreignKey = CellUtil.getStringCellValue(fKeyCell);
		String foreignPropertyName = CellUtil.getStringCellValue(fPropertyNameCell);
		String note = CellUtil.getStringCellValue(noteCell);
		
		DbProperty property = new DbProperty();
		property.setPropertyName(propertyName);
		property.setPropertyType(propertyType);
		property.setFieldName(fieldName);
		property.setFieldType(fieldType);
		property.setFieldDef(fieldDef);
		property.setNon(fieldNon);
		property.setSize(fieldSize);
		property.setPrimary(primary);
		if(foreignTable != null && foreignTable.length() > 0 ){
			if( foreignKey == null || foreignKey.length() == 0 ){
			    throw new MappingToolException("OQƃL[ZbgĂBOQƃe[u[" + foreignTable + "]" + 
				    	" V[gԍ[" + sheetNo + "]" + 
				    	" sԍ[" + rowNo + "]");
			}
			if( foreignPropertyName == null || foreignPropertyName.length() == 0 ){
			    throw new MappingToolException("OQƃp[^ZbgĂBOQƃe[u[" + foreignTable + "]" + 
				    	" V[gԍ[" + sheetNo + "]" + 
				    	" sԍ[" + rowNo + "]");
			}
		    property.setForeignTable(foreignTable);
			property.setForeignKey(foreignKey);
			property.setForeignPropertyName(foreignPropertyName);
		}
		property.setNote(note);
		
		return property;
	}
	
	/**
	 * DBdlǗLinkedListCX^XԂ܂
	 * @return DBdlǗLinkedListCX^XԂ܂
	 */
//	public LinkedList getTableMap() {
	public HashMap getTableMap() {
		return tableMap;
	}
}
