package org.itscool.commons.daotool.data;

import org.apache.poi.hssf.usermodel.HSSFCell;

/**
 *  POIɂExcel֐Ɋւ郆[eBeBNXł
 * @author kano
 * 쐬F 2004/12/27
 */
public class CellUtil {
	
	/**
	 * w肳ꂽZ̒l𕶎Ŏ擾܂
	 * @param cell Z
	 * @return Z̒l𕶎ŕԂ܂
	 */
	public static String getStringCellValue(HSSFCell cell){
		String value = "";
		if( cell == null){
			return value;
		}
		
		if(cell.getCellType() == HSSFCell.CELL_TYPE_STRING){
			value = cell.getStringCellValue();
		}else if(cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC){
			value = String.valueOf(cell.getNumericCellValue());
		}else if(cell.getCellType() == HSSFCell.CELL_TYPE_BOOLEAN){
			value = String.valueOf(cell.getNumericCellValue());
		}
		if(value == null){
			value = "";
		}
		return value;
	}
	
	/**
	 * w肳ꂽZ̒ldoublelŕԂ܂
	 * @param cell Z
	 * @return Z̒ldoublelŕԂ܂
	 */
	public static double getNumericCellValue(HSSFCell cell){
		double value = -1;
		
		if( cell == null){
			return value;
		}
		if(cell.getCellType() == HSSFCell.CELL_TYPE_STRING){
			try{
				value = Double.valueOf(cell.getStringCellValue()).doubleValue();
			}catch(NumberFormatException nfe){
				nfe.printStackTrace();
			}
		}else if(cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC){
			value = cell.getNumericCellValue();
		}
		
		return value;
	}

	/**
	 * w肳ꂽZ̒lbooleanlŕԂ܂
	 * @param cell Z
	 * @return Z̒lbooleanlŕԂ܂
	 */
	public static boolean getBooleanCellValue(HSSFCell cell){
		boolean value = false;
		
		if( cell == null){
			return value;
		}
		if(cell.getCellType() == HSSFCell.CELL_TYPE_STRING){
			String strValue = cell.getStringCellValue().trim();
			strValue = strValue.toLowerCase();
			if(strValue.equals("true")){
				value = true;
			}else{
				value = false;
			}
		}else if(cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC){
			int intValue = (int)(cell.getNumericCellValue());
			if( intValue > 0){
				value = true;
			}else{
				value = false;
			}
		}else if(cell.getCellType() == HSSFCell.CELL_TYPE_BOOLEAN){
			value = cell.getBooleanCellValue();
		}
		return value;
	}

}
