package org.itscool.commons.daotool;

import java.util.HashMap;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.daotool.data.DbPropertyReader;
import org.itscool.commons.daotool.velocity.BeanListVelocityWriter;
import org.itscool.commons.daotool.velocity.BeanVelocityWriter;
import org.itscool.commons.daotool.velocity.DaoVelocityWriter;
import org.itscool.commons.daotool.velocity.RegistActionVelocityWriter;
import org.itscool.commons.daotool.velocity.SearchActionVelocityWriter;
import org.itscool.commons.daotool.velocity.SqlVelocityWriter;
import org.itscool.commons.daotool.velocity.VelocityWriter;

//import org.itscool.commons.file.PropertyFile;
//import org.itscool.dbmaptool.property.DbProperty;
//import org.itscool.dbmaptool.property.DbPropertyList;

/**
 * DB}bvc[s郁CNXł<BR>
 * 
 * Excelō쐬DBdle[u쐬pSQLt@CAAm[e[V`
 * tJavaBeans𐶐܂<br>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/12/26 VK쐬
 * @varsion 1.10A 2006/03/08 G[bZ[WɃV[gԍƍsԍǉ
 */
public class MappingTool {
    public static final String DOCUMENT_PATH="docpath";
    public static final String TEMPLATE_PATH="tmppath";
    public static final String ENCODE="encode";
    public static final String DB="db";
    public static final String OUT="out";
    public static final String SQL_TEMP_VM="sqlTemplate.vm";
    public static final String BEAN_TEMP_VM="beanTemplate.vm";
    public static final String BEANLIST_TEMP_VM="beanListTemplate.vm";
    public static final String START_SHEET_INDEX="startSheetIndex";
    /**
     * e[u쐬pSQLAJavaBeans̍쐬Jn܂
     * @param argv argv[0]Ƀ}bsOc[`t@Ciitscool-dbmapper.cfgj
     * ̃pX(t@C܂)w肵ĂB
     * @throws Exception
     */
	public static void main(String[] argv) throws Exception{
        
		new MappingTool("di-config.xml");
	}
	
	/**
	 * MAppingToolCX^X̏ƃe[u쐬pSQLAJavaBeans̍쐬Jn܂
     * @throws Exception
	 */
	public MappingTool(String configName) throws Exception{
		try{
			BeanFactory factory = new BeanFactory();
			try{
        		factory.createForUrl(configName);
        	}catch(Exception ex){
        		ex.printStackTrace();
            	throw new Exception(ex.getMessage());
        	}    
			MappingToolInfo info = (MappingToolInfo)factory.createInstance("MappingToolInfo");
	        String docpath = info.getInfo(DOCUMENT_PATH);
	        String tmppath = info.getInfo(TEMPLATE_PATH);
	        String encode = info.getInfo(ENCODE);
	        String db = info.getInfo(DB);
	        String out = info.getInfo(OUT);
	        int startSheetIndex = 0;
	        try{
	        	startSheetIndex = Integer.parseInt(info.getInfo(START_SHEET_INDEX));
	        }catch(NumberFormatException nfe){
	        	throw new MappingToolException("ǎJnV[gԍZbgĂ");
	        }
	        if(docpath == null || docpath.length() == 0 ){
			    throw new MappingToolException("hLg̃pXZbgĂ");
			}
	        if(tmppath == null || tmppath.length() == 0 ){
			    throw new MappingToolException("ev[g̃pXZbgĂ");
			}
	        if(encode == null || encode.length() == 0 ){
			    throw new MappingToolException("GR[fBOZbgĂ");
			}
	        if(db == null || db.length() == 0 ){
			    throw new MappingToolException("ca̎ނZbgĂ");
			}
	        if(out == null || out.length() == 0 ){
			    throw new MappingToolException("o͐̃pXZbgĂ");
			}
	        
	        System.out.println("hLg̃pX" + docpath);
	        System.out.println("ev[g̃pX" + tmppath);
	        System.out.println("GR[fBO  " + encode);
	        System.out.println("ca̎        " + db);
	        System.out.println("o͐̃pX      " + out);
	        System.out.println("----- hLg\ -----");
	        System.out.println("ǎJnV[gԍ      " + startSheetIndex);
	        
			DbPropertyReader reader = new DbPropertyReader();
	//		LinkedList tableList = reader.create(docpath);
			HashMap tableList = reader.create(docpath, startSheetIndex);
			VelocityWriter sqlWriter = new SqlVelocityWriter(tableList);
			sqlWriter.execute(tmppath, SQL_TEMP_VM, out, encode);
			VelocityWriter beanWriter = new BeanVelocityWriter(tableList);
			beanWriter.execute(tmppath, BEAN_TEMP_VM,out, encode);
			VelocityWriter beanListWriter = new BeanListVelocityWriter(tableList);
			beanListWriter.execute(tmppath, BEANLIST_TEMP_VM,out, encode);
			VelocityWriter daoWriter = new DaoVelocityWriter(tableList);
			daoWriter.execute(tmppath, "daoTemplate.vm",out, encode);
			VelocityWriter sActionWriter = new SearchActionVelocityWriter(tableList);
			sActionWriter.execute(tmppath, "sActionTemplate.vm",out, encode);
			VelocityWriter rActionWriter = new RegistActionVelocityWriter(tableList);
			rActionWriter.execute(tmppath, "rActionTemplate.vm",out, encode);
	        
	        System.out.println("I܂");
		}catch(Exception e){
			e.printStackTrace();
			System.out.println("ُI܂");
			throw e;
		}
	}
	
//	public void showInfo(LinkedList tableList){
//		for( int i=0; i<tableList.size(); i++ ){
//            DbPropertyList propertyList = (DbPropertyList)tableList.get(i);
//            System.out.println("********************************************");
//            System.out.println(propertyList.toString());
//            System.out.println("--------------------------------------------");
//            for( int j=0; i<propertyList.size(); j++ ){
//                DbProperty property = (DbProperty)propertyList.get(j);
//                System.out.println(property.toString());
//            }
//        }
//	}
}



