package org.itscool.commons.dao;

import java.io.IOException;
import java.util.HashMap;

import org.itscool.commons.file.ConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * dao-config.xmlt@C&lt;beans&gt;vf͂NXł<BR>
 * dao-config.xmlɂ́AiΏۂƂȂNX`ĂA
 * DaoConfigReaderNXɂāAiΏۃNX̏擾A
 * DaoMappingNXɃZbg܂B<BR>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/10/10
 */
public class DaoConfigReader extends ConfigReader{
    
    /**
     * XMLt@C&lt;roles&gt;vf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param hashMap XML̉͌
    */
    protected void doCreate(HashMap hashMap) throws IOException{
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at weber-message.xml(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        /* action-mappings ̎擾*/
        NodeList rolesList = root.getElementsByTagName("beans");
        if( rolesList != null ){
            Node roles = rolesList.item(0);
            if( roles != null ){
                createDaos(roles, hashMap);
            }
        }
    }
    
    /**
     * &lt;message&gt;vf͂܂
     * @param roles &lt;massages&gt;vf
     * @param hashMap ͌&lt;massages&gt;vfǉm[hXg
     * @throws Exception
     */
    protected void createDaos(Node roles, HashMap hashMap){
        NodeList rolesChilds = roles.getChildNodes();
        
        for( int i = 0; i < rolesChilds.getLength(); i++) {
            Node message = rolesChilds.item(i);
            if( message.getNodeName().equals("bean")){
                createDao(message, hashMap);
            }
        }
    }
    
    /**
     * &lt;message&gt;vf̑͂܂
     * @param message &lt;message&gt;vf
     * @param hashMap ͌&lt;message&gt;vfǉm[hXg
     * @throws Exception
     */
    protected void createDao(Node message, HashMap hashMap){
        NamedNodeMap attributes = message.getAttributes();
        Node name = attributes.getNamedItem("name");
        String entity = name.getNodeValue();
        RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
        HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
        DaoInfo daoInfo = new DaoInfo();
        daoInfo.setGRecordMap(gRecordMap);
        daoInfo.setFkRecordMaps(fkRecordMaps);
        
        hashMap.put( entity, daoInfo );
        
    }
}
