package org.itscool.commons.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.connection.TransactionUtil;

/**
 * {f[^ANZXNX<P>
 * CriteriaCX^XɊÂgUNVs
 * {f[^ANZXNXł<BR>
 * O/R}bsO@\𗘗pɂ́ÃNXpf[^ANZXNX
 * 쐬Ȃ΂Ȃ܂<BR>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
*/
public class BaseDao {
    /**
     * gUNVCX^X
     */
    protected Transaction transaction;
    
    public BaseDao(){
    	transaction = TransactionUtil.getTransaction();
    	if(transaction == null){
    		throw new RuntimeException(BaseDao.class.getName() + " transaction is null.");
    	}
    }
    
	/**
	 * DaoTransactionCX^X܂
	 * @param trn TransactionCX^X
	 */
	public void setTransaction(Transaction trn){
		this.transaction = trn;
	}

    /**
     * TransactionCX^X擾܂<BR>
     * SQL𒼐ڎsꍇ́ATransactionCX^X񋟂
     * \bhgp܂
     * @return TransactionCX^XԂ܂
     */
    public Transaction getTransaction() {
        return transaction;
    }

	/**
	 * INSERTs܂
	 * @param crt CriteriaCX^X
	 * @param bean INSERTsBeanCX^X
	 * @throws TransactionException
	 */
	public void insert(Criteria crt, Object bean)
    throws TransactionException{
    	String sql = crt.toInsertString(bean);
    	transaction.execute(sql);
    }
    
    /**
     * UPDATEs܂
     * @param crt CriteriaCX^X
     * @throws TransactionException
     */
    public void update(Criteria crt, Object bean)
    throws TransactionException{
    	String sql = crt.toUpdateString(bean);
        transaction.execute(sql);
    }
    /**
     * DELETEs܂
     * @param crt CriteriaCX^X
     * @throws TransactionException
     */
    public void delete(Criteria crt)
    throws TransactionException{
        String sql = crt.toDeleteString();
        transaction.execute(sql);
    }
    
    /**
     * SELECTsAsʂBeanCX^X̔zŕԂ܂
     * @param crt CriteriaCX^X
     * @return SELECT̎sʂBeanCX^X̔zŕԂ܂
     * @throws TransactionException
     */
    public List select(Criteria crt) throws TransactionException{
    	ArrayList result = new ArrayList();
    	ArrayList list = null;
        
        //SQLs
    	//sʂRecordNX̔zŎ擾܂
        list = transaction.select(crt.toSelectString());
        
        //CriteriaCX^XɃZbgꂽRecordMapCX^X擾܂
        RecordMap recordMap = crt.getRecord();
        //select\bhŎ擾RecordCX^XCrieteriaCX^X
        //ŃZbgĂRecordMapCX^XJavaBeansCX^X
        //܂
        for(int i=0; i<list.size(); i++){
        	Record record = (Record)list.get(i);
        	Object obj = createObject(recordMap, record);
        	
        	//OQƏ̎擾
        	HashMap fkRecordMaps = crt.getFkRecordMaps();
        	Set keySet = fkRecordMaps.keySet();
        	Iterator it = keySet.iterator();
        	//OQƏ񂪒`Ăꍇ́AOQƏɕRtlR[h
        	//擾AOQƃIuWFNg쐬
        	while(it.hasNext()){
        	    String propertyName = (String)it.next();
        	    //OQƗpRecordMapCX^X擾
        	    RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(propertyName);
        	    String fkClassName = fkRecordMap.getClassName();
        	    //OQƗpRecordMapɊÂRecordMapCX^XVɐ
        	    RecordMap joinRecordMap = RecordMapFactory.createRecordMap(fkClassName);
        	    //OQƃIuWFNg쐬
                Object fkObj = createObject(joinRecordMap, record);
                //OQƃIuWFNgʃIuWFNgɃZbg
        	    BeanUtil.setProperty(obj, propertyName, fkObj);
        	}
            result.add(obj);
        }
        
        return result;
    }
    
    /**
     * Transaction.select\bhŎ擾RecordCX^XCriteriaCX^X
     * ŃZbgĂRecordMapCX^XJavaBeansCX^X𐶐܂
     * @param recordMap RecordMapCX^X
     * @param record RecordCX^X
     * @return ꂽJavaBeansCX^XԂ܂
     * @throws TransactionException
     */
    private Object createObject(RecordMap recordMap, Record record)
    throws TransactionException{
    	Object obj = BeanUtil.createInstance(recordMap.getClassName());
    	//RecordMap newRecord = new RecordMap(recordMap.getClassName(), recordMap.getTableName());
    	Set keySet = recordMap.getFields().keySet();
    	Iterator it = keySet.iterator();
        while( it.hasNext() ){
            Object key = it.next();
            FieldMap field = (FieldMap)recordMap.getFields().get(key);
            Object value = record.get(field.getColumAsName());
            
            try{
            	//BeanUtil.setProperty(obj,field.getPropertyName(),value);
                field.setPropertyValue(obj, value);
            }catch(Exception e){
            	System.out.print(obj.getClass().getName() + ":");
            	System.out.print(field.getPropertyName());
                System.out.println( ":" + value);
            	e.printStackTrace();
            }
        }
        return obj;
    }
    /**
     * USERe[uVid擾܂
     * @return VKo^pidԂ܂
     */
    public int getNewId(String tableName, String pkCulomName){
        int id = 0;    
        StringBuffer sql = new StringBuffer();
        sql.append("select MAX(");
        sql.append(tableName).append(".").append(pkCulomName);
        sql.append(") AS NEW_ID FROM ").append(tableName);
        
        Records result = transaction.select(sql.toString());
        if(result.size() > 0){
            Record record = (Record)result.getRecord(0);
            id = record.getInt("NEW_ID");
            id ++;
        }
        return id;
    }
    
    /**
     * AUTONUMBERe[ugUSERe[uVid
     * 擾܂
     * @return VKo^pidԂ܂
     */
    public int getNewIdFromAutoNumber(String tableName){
        int id = 0;    
        AutoNumberDao dao = new AutoNumberDao();
        id = dao.getNext(tableName);
        return id;
    }
    
//    /**
//     * R~bgs܂<BR>
//     * R~bgɎsƃ[obNs܂
//     * @throws TransactionException
//     */
//    public void commit() throws TransactionException{
//        try{
//            // R~bg܂
//            transaction.commit();
//        }catch(TransactionException e){
//            throw e;
//        }
//    }
//
//    /**
//     * [obNs܂
//     * @throws TransactionException
//     */
//    public void rollback() throws TransactionException{
//        transaction.rollback();
//    }
//
//  /**
//   * e[uĂtB[hIuWFNg̃vpeB
//   * Ƀ}bsO܂
//   * @param bean tB[hɃZbgꂽlZbgBeanIuWFNg
//   * @param crt CriteriaCX^X
//   * @param rs RecordMapCX^X̔z
//   * @throws TransactionException
//   */
//  private void addLinkObject(Object bean, Criteria crt, 
//  		HashMap linkRecords, HashMap rs) throws TransactionException{
//  	Set keySet = linkRecords.keySet();
//  	Iterator it = keySet.iterator();
//      while( it.hasNext() ){
//          Object key = it.next();
//          RecordMap record = (RecordMap)linkRecords.get(key);
//          Object property = createObject(record, crt, rs);
//          
//          //System.out.println(record.getClassOnlyName());
//          try{
//          	BeanUtil.setProperty(bean, record.getClassOnlyName(), property);
//      
//          }catch(Exception e){
//          	e.printStackTrace();
//          }
//      }
//  }
    
}
