package test.org.itscool.webersample.dao;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.itscool.commons.connection.TransactionUtil;
import org.itscool.webersample.bean.OfficialTitle;
import org.itscool.webersample.dao.OfficialTitleDao;
import org.itscool.webertest.testcase.WeberDbTestCase;

/**
 * 쐬: 2005/06/28
 * @author kanoum
 */
public class TestOfficialTitleDao extends WeberDbTestCase{
    
    public void setUp(){
    	this.initTables("test-db-data.xml");
    	this.clearTables();
    }
    
    public void testSave(){
        OfficialTitleDao dao = new OfficialTitleDao();
        OfficialTitle title = new OfficialTitle();
        title.setName("C");
        title.setTitleId("100");
        
        try{
            dao.save(title);
            //R~bgȂ
            TransactionUtil.rollbackTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testUpdate(){
        OfficialTitleDao dao = new OfficialTitleDao();
        OfficialTitle title = new OfficialTitle();
        title.setName("C");
        title.setTitleId("100");
        
        try{
            dao.save(title);
            
            title.setName("ے");
            dao.update(title);
            
            //R~bgȂ
            TransactionUtil.rollbackTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testDelete(){
        OfficialTitleDao dao = new OfficialTitleDao();
        OfficialTitle title = new OfficialTitle();
        title.setName("C");
        title.setTitleId("100");
        
        try{
            dao.save(title);
            dao.delete(title);
            //R~bgȂ
            TransactionUtil.rollbackTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
	public static Test suite() {
		return new TestSuite(TestPostDao.class);
	}
}
